/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Timer;
import java.util.logging.Logger;
import oracle.ucp.util.TimerHandle;
import oracle.ucp.util.TimerManager;
import oracle.ucp.util.TimerTask;
import oracle.ucp.util.UCPTimerTaskImpl;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class UCPTimerManagerImpl
implements TimerManager {
    private static final Logger logger = UCPLoggerFactory.createLogger(UCPTimerManagerImpl.class.getCanonicalName());
    private final Set<Timer> m_setTimers = new LinkedHashSet<Timer>();
    private boolean m_running = false;

    private synchronized TimerHandle scheduleHelper(boolean fixed, TimerTask task, long delay, long interval) {
        if (!(task instanceof UCPTimerTaskImpl)) {
            logger.finest("wrong timer task");
            return null;
        }
        UCPTimerTaskImpl ucpTimerTask = (UCPTimerTaskImpl)task;
        final Timer timer = new Timer(true);
        if (fixed) {
            timer.scheduleAtFixedRate((java.util.TimerTask)ucpTimerTask, delay, interval);
        } else {
            timer.schedule((java.util.TimerTask)ucpTimerTask, delay, interval);
        }
        this.m_setTimers.add(timer);
        final UCPTimerManagerImpl timerManagerThis = this;
        return new TimerHandle(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void cancel() {
                Object object = timerManagerThis;
                synchronized (object) {
                    timer.cancel();
                    UCPTimerManagerImpl.this.m_setTimers.remove(timer);
                }
            }
        };
    }

    public synchronized boolean isRunning() {
        return this.m_running;
    }

    public synchronized TimerHandle schedule(TimerTask task, long delay, long interval) {
        return this.scheduleHelper(false, task, delay, interval);
    }

    public synchronized TimerHandle scheduleAtFixedRate(TimerTask task, long delay, long interval) {
        return this.scheduleHelper(true, task, delay, interval);
    }

    public synchronized void start() {
        this.m_running = true;
    }

    public synchronized void stop() {
        this.m_running = false;
    }
}

