/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.metadatamanager.util;

import com.ericsson.metadatamanager.util.ECMFDocToXpathConverter;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.search.SearchSchemaHelper;
import com.tandbergtv.metadatamanager.util.binder.ECMFFieldBinder;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class BadDataHandler {
    public static final String ref_xml = "com/ericsson/metadatamanager/util/ECMFSpec.xml";
    private static final Logger logger = Logger.getLogger(BadDataHandler.class);
    private static BadDataHandler instance = null;
    private Map<String, String> allValidFieldXpaths = null;

    public static synchronized BadDataHandler getInstance() {
        if (instance == null) {
            instance = new BadDataHandler();
        }
        return instance;
    }

    private BadDataHandler() {
        this.initMapForAllValidFieldXpaths();
    }

    private void initMapForAllValidFieldXpaths() {
        Document doc = null;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputStream is = ECMFFieldBinder.class.getClassLoader().getResourceAsStream(ref_xml);
            doc = builder.parse(new InputSource(is));
            ECMFDocToXpathConverter converter = new ECMFDocToXpathConverter();
            this.allValidFieldXpaths = converter.convert(doc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> getAllFieldXpaths(String fileName) {
        Map<String, String> lookUp = null;
        Document doc = null;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            FileReader fstream = new FileReader(fileName);
            BufferedReader buffedIn = new BufferedReader(fstream);
            doc = builder.parse(new InputSource(buffedIn));
            ECMFDocToXpathConverter converter = new ECMFDocToXpathConverter();
            lookUp = converter.convert(doc);
            return lookUp;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isValidFieldXPath(String xPath) {
        String val = this.allValidFieldXpaths.get(xPath);
        return val != null;
    }

    public Field setFieldForInvalidXpath(Field f) {
        String ttvXPath = f.getTtvXPath();
        if (ttvXPath.startsWith("/Fields/CustomFields/CustomField") || ttvXPath.equals("/Fields")) {
            return f;
        }
        ArrayList<Integer> newIndices = new ArrayList<Integer>();
        if (ttvXPath.startsWith("/Fields/CustomField")) {
            int ndx = new String("/Fields/CustomField").length();
            String part = ttvXPath.substring(ndx);
            f.setTtvXPath("/Fields/CustomFields/CustomField" + part);
            List indices = f.getIndices();
            newIndices.add(new Integer(1));
            for (int i = 0; i < indices.size(); ++i) {
                newIndices.add((Integer)indices.get(i));
            }
            f.setIndices(newIndices);
        } else {
            int ndx = new String("/Fields/").length();
            String part = ttvXPath.substring(ndx);
            StringBuilder b = new StringBuilder("/Fields/CustomFields/CustomField[@name=");
            b.append(part.replaceAll("/", "."));
            b.append("]/@value");
            f.setTtvXPath(b.toString());
            for (int i = 0; i < 3; ++i) {
                newIndices.add(new Integer(1));
            }
            f.setIndices(newIndices);
        }
        logger.info((Object)("***invalid xpath:replacing " + ttvXPath + " with " + f.getTtvXPath()));
        return f;
    }

    public Field checkAndFixSpecificField(Field f) {
        String ttvXPath = f.getTtvXPath();
        if (ttvXPath.startsWith("/Fields/Audio/Types")) {
            int typesIndex;
            List indices = f.getIndices();
            if (indices.size() > 3 && (typesIndex = ((Integer)indices.get(2)).intValue()) > 1) {
                ArrayList<Integer> newIndices = new ArrayList<Integer>();
                for (int i = 0; i < 3; ++i) {
                    newIndices.add(new Integer(1));
                }
                newIndices.add(typesIndex);
                f.setIndices(newIndices);
            }
        } else if (ttvXPath.startsWith("/Fields/CreationInfo/Title")) {
            int titleIndex;
            List indices = f.getIndices();
            if (indices.size() > 3 && (titleIndex = ((Integer)indices.get(2)).intValue()) > 1) {
                int i;
                ArrayList<Integer> newIndices = new ArrayList<Integer>();
                for (i = 0; i < 3; ++i) {
                    newIndices.add(new Integer(1));
                }
                for (i = 3; i < indices.size(); ++i) {
                    newIndices.add((Integer)indices.get(i));
                }
                f.setIndices(newIndices);
            }
        } else if (ttvXPath.startsWith("/Fields/Video")) {
            int videoIndex;
            List indices = f.getIndices();
            if (indices.size() > 2 && (videoIndex = ((Integer)indices.get(1)).intValue()) > 1) {
                int i;
                ArrayList<Integer> newIndices = new ArrayList<Integer>();
                for (i = 0; i < 2; ++i) {
                    newIndices.add(new Integer(1));
                }
                for (i = 2; i < indices.size(); ++i) {
                    newIndices.add((Integer)indices.get(i));
                }
                f.setIndices(newIndices);
            }
        } else if (ttvXPath.startsWith("/Fields/CustomFields") && ttvXPath.endsWith("/value")) {
            String[] parts = ttvXPath.split("/");
            StringBuilder b = new StringBuilder("/Fields/CustomFields/");
            b.append(parts[3]);
            b.append("/@value");
            f.setTtvXPath(b.toString());
            List indices = f.getIndices();
            if (indices.size() > 3) {
                ArrayList newIndices = new ArrayList();
                for (int i = 0; i < 3; ++i) {
                    newIndices.add(indices.get(i));
                }
                f.setIndices(newIndices);
            }
        }
        return f;
    }

    public void dumpAllValidFieldXpaths() {
        Set<String> keys = this.allValidFieldXpaths.keySet();
        for (String key : keys) {
            System.out.println(key);
        }
    }

    public static void main(String[] args) {
        BadDataHandler test = BadDataHandler.getInstance();
        String badXPath = "/Fields/CustomField/@name";
        String goodXPath = "/Fields/ApplicationInfo/Name";
        boolean isValid = test.isValidFieldXPath(badXPath);
        System.out.println("isValid=" + test.isValidFieldXPath(badXPath) + " for " + badXPath);
        System.out.println("isValid=" + test.isValidFieldXPath(goodXPath) + " for " + goodXPath);
        Field f = new Field();
        f.setTtvXPath(badXPath);
        test.setFieldForInvalidXpath(f);
        System.out.println("new xpath=" + f.getTtvXPath());
        SearchSchemaHelper schHelper = new SearchSchemaHelper();
        String fldXpath = "/Fields/Rating/ContentAdvisories/ContentAdvisory";
        Long start = System.currentTimeMillis();
        List nodes = schHelper.getXpathCardinality("PACKAGE/TITLE", fldXpath);
        System.out.println("Time taken=" + (System.currentTimeMillis() - start));
        System.out.println("nodes=" + nodes.toString());
    }
}

