/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.communication.handlers;

import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.communication.config.MessageHandler;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleService;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.File;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class GetTitleIdsMessageHandler
implements MessageHandler {
    private static final String METADATA_PATH = "metadataPath";
    private static final String TITLE_IDS = "titleIds";
    private static final String TITLE_ID_DELIMITER = ",";

    @Override
    public WorkflowMessage handleMessage(WorkflowMessage message) throws Exception {
        WorkflowMessage response = new WorkflowMessage(message.getMessageUID(), message.getKey(), WorkflowMessage.MessageType.ack);
        Util.validateRequired(message, METADATA_PATH);
        String metadataFilePath = Util.getStringValueTrimmed(message, METADATA_PATH);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        Document metadata = docBuilder.parse(new File(metadataFilePath));
        ServiceRegistry defaultServiceRegistry = ServiceRegistry.getDefault();
        ITitleService titleService = (ITitleService)defaultServiceRegistry.lookup(ITitleService.class);
        Collection titles = titleService.getTitle(metadata);
        StringBuilder sb = new StringBuilder();
        for (Title t : titles) {
            if (sb.length() > 0) {
                sb.append(TITLE_ID_DELIMITER);
            }
            sb.append(String.valueOf(t.getId()));
        }
        response.putValue(TITLE_IDS, sb.toString());
        return response;
    }
}

