/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.SearchColumn;
import com.tandbergtv.metadatamanager.search.ConditionBuilder;
import com.tandbergtv.metadatamanager.search.SearchSchemaHelper;
import com.tandbergtv.metadatamanager.search.assetconditionbuilder.AssetConditionBuilder;
import com.tandbergtv.metadatamanager.util.CustomFieldXPathConverter;
import java.util.ArrayList;
import java.util.List;

public class AssetSearchQueryBuilder {
    private static final String MDM_ALIAS = "mdm";
    public static final String DOCID_ALIAS = "docId";
    private static final String COL_ALIAS = "mdm_col";

    public String buildQuery(ExpNode condition, boolean onlyOriginals, Long docIdToExclude) {
        return this.buildQuery(condition, new ArrayList<SearchColumn>(), onlyOriginals, docIdToExclude);
    }

    public String buildQuery(ExpNode condition, List<SearchColumn> resultColumns, boolean onlyOriginals, Long docIdToExclude) {
        StringBuilder query = new StringBuilder();
        this.buildSelect(query, resultColumns);
        query.append("from mdm_metadata ");
        query.append(MDM_ALIAS);
        query.append("\r\n");
        if (condition != null) {
            this.buildSingleAssetCondition(query, condition);
        }
        if (docIdToExclude != null) {
            query.append(" AND xmlexists('$p/ECMFSpec[@documentId!=");
            query.append(docIdToExclude);
            query.append("]' passing sys_nc_rowinfo$ AS \"p\")");
        }
        if (onlyOriginals) {
            if (condition != null) {
                query.append(" and ");
            }
            query.append(this.getOnlyOriginals());
        }
        return query.toString();
    }

    public String buildQueryForFullDoc(ExpNode condition, boolean onlyOriginals) {
        StringBuilder query = new StringBuilder();
        query.append("select XMLSERIALIZE(content mdm.OBJECT_VALUE as clob no indent) \r\n");
        query.append("from mdm_metadata mdm\r\n");
        if (condition != null) {
            this.buildSingleAssetCondition(query, condition);
        }
        if (onlyOriginals) {
            if (condition != null) {
                query.append(" and ");
            }
            query.append(this.getOnlyOriginals());
        }
        return query.toString();
    }

    public String getOnlyOriginals() {
        LogicalOperator operator = LogicalOperator.ISNULL;
        Predicate origAssetCond = new Predicate("/@originalDocumentId", "ECMFSpec", FieldType.ASSET, operator, Boolean.valueOf(false));
        return ConditionBuilder.getCondition(origAssetCond);
    }

    private void buildSelect(StringBuilder query, List<SearchColumn> resultColumns) {
        query.append("Select ");
        boolean appendedDocId = false;
        for (int i = 0; i < resultColumns.size(); ++i) {
            SearchColumn sc = resultColumns.get(i);
            if (i > 0) {
                query.append(", ");
            }
            if (sc.getFieldName().equals("@documentId")) {
                appendedDocId = true;
                query.append(AssetSearchQueryBuilder.getExtractValue("ECMFSpec", "/@documentId"));
                query.append(" as ");
                query.append(DOCID_ALIAS);
                continue;
            }
            query.append(AssetSearchQueryBuilder.getExtractValue(sc.getSectionType(), sc.getFieldName()));
            query.append(" as ");
            query.append(COL_ALIAS + i);
        }
        if (!appendedDocId) {
            if (resultColumns.size() > 0) {
                query.append(", ");
            }
            query.append(AssetSearchQueryBuilder.getExtractValue("ECMFSpec", "/@documentId"));
            query.append(" as ");
            query.append(DOCID_ALIAS);
        }
        query.append("\r\n");
    }

    private void buildSingleAssetCondition(StringBuilder query, ExpNode condition) {
        query.append("where xmlexists('$p");
        String assetType = this.findFirstAssetType(condition);
        if (assetType.isEmpty() || assetType.equals("/") || assetType.equals("//")) {
            query.append("//*");
        } else {
            query.append(AssetSearchQueryBuilder.getEcmfComplientSectionType(assetType, true));
        }
        query.append("[");
        this.buildSingleAssetConditionRec(query, condition);
        query.append(" ]' passing sys_nc_rowinfo$ AS \"p\")");
    }

    private String findFirstAssetType(ExpNode condition) {
        if (condition instanceof ExpValue) {
            Predicate predicate = ((ExpValue)condition).getPredicate();
            return predicate.getFieldLeftSectionType();
        }
        if (condition instanceof ExpList) {
            ExpList list = (ExpList)condition;
            List nodes = list.getNodes();
            for (int i = 0; i < nodes.size(); ++i) {
                ExpNode node = (ExpNode)nodes.get(i);
                String assetType = this.findFirstAssetType(node);
                if (assetType == null) continue;
                return assetType;
            }
        }
        return null;
    }

    private void buildSingleAssetConditionRec(StringBuilder query, ExpNode condition) {
        if (condition instanceof ExpValue) {
            Predicate predicate = ((ExpValue)condition).getPredicate();
            query.append(AssetConditionBuilder.getCondition(predicate));
        } else if (condition instanceof ExpList) {
            ExpList list = (ExpList)condition;
            List nodes = list.getNodes();
            String listOperator = list.getOperator() == "AND" ? " and " : " or ";
            query.append("(");
            for (int i = 0; i < nodes.size(); ++i) {
                ExpNode node = (ExpNode)nodes.get(i);
                if (i > 0) {
                    query.append(listOperator);
                }
                this.buildSingleAssetConditionRec(query, node);
            }
            query.append(")");
        }
    }

    public static String getMultiValueSelect(String assetType, String xpath) {
        StringBuilder sb = new StringBuilder();
        sb.append("XMLCAST(XMLQuery('string-join($p");
        if (!xpath.startsWith("/")) {
            sb.append("*");
        }
        sb.append(AssetSearchQueryBuilder.getEcmfComplientSectionTypeWIndices(assetType, true));
        sb.append(xpath);
        sb.append(", \",\")' PASSING sys_nc_rowinfo$ AS \"p\" RETURNING CONTENT) as varchar2(2000))");
        return sb.toString();
    }

    public static String getCustmFieldSelect(String assetType, String xpath) {
        StringBuilder sb = new StringBuilder();
        sb.append("xmlcast(XMLQuery('");
        sb.append(AssetSearchQueryBuilder.getEcmfComplientSectionTypeWIndices(assetType, true));
        sb.append(CustomFieldXPathConverter.getActualXpath(xpath));
        sb.append("' PASSING mdm.OBJECT_VALUE RETURNING CONTENT) AS VARCHAR2(2000))");
        return sb.toString();
    }

    public static String getExtractValue(String assetType, String xpath) {
        if (SearchSchemaHelper.isCustomField(xpath)) {
            return AssetSearchQueryBuilder.getCustmFieldSelect(assetType, xpath);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("extractvalue(sys_nc_rowinfo$, '");
        sb.append(AssetSearchQueryBuilder.getDisplayXpath(assetType, xpath));
        sb.append("')");
        return sb.toString();
    }

    public static String getDisplayXpath(String assetType, String xpath) {
        if (assetType.endsWith("ECMFSpec")) {
            return assetType + xpath;
        }
        SearchSchemaHelper ssh = new SearchSchemaHelper();
        return ssh.prepareSelectXpath(assetType, xpath);
    }

    public static String getEcmfComplientSectionTypeWIndices(String assetType, boolean includeEcmf) {
        return AssetSearchQueryBuilder.getEcmfComplientSectionType(assetType, includeEcmf, true);
    }

    public static String getEcmfComplientSectionType(String assetType, boolean includeEcmf) {
        return AssetSearchQueryBuilder.getEcmfComplientSectionType(assetType, includeEcmf, false);
    }

    private static String getEcmfComplientSectionType(String assetType, boolean includeEcmf, boolean includeIndex) {
        StringBuffer sb = new StringBuffer();
        if (assetType.isEmpty() || assetType.startsWith("//")) {
            return "/";
        }
        if (assetType.startsWith("/")) {
            return assetType;
        }
        if (assetType.startsWith("ECMFSpec")) {
            return "/" + assetType;
        }
        if (includeEcmf) {
            sb.append("/ECMFSpec/");
        }
        if (!assetType.toUpperCase().startsWith("PACKAGE")) {
            sb.append("Package/");
        }
        SearchSchemaHelper ssh = new SearchSchemaHelper();
        sb.append(ssh.getCorrectedAssetPath(assetType, includeIndex));
        return sb.toString();
    }

    public static String encodeString(String str) {
        char[] characters = str.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (char c : characters) {
            if (c == '_' || c == '-') {
                sb.append("\\");
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

