/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager;

import com.tandbergtv.metadatamanager.RuleManagerDAO;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.model.RuleSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class RuleManagerDAOImpl
implements RuleManagerDAO {
    private HibernateTemplate template;
    private static final Logger logger = Logger.getLogger(RuleManagerDAOImpl.class);

    public HibernateTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(HibernateTemplate template) {
        this.template = template;
    }

    @Override
    public void deleteRuleSet(long id) throws SearchException {
        this.getTemplate().delete((Object)new RuleSet(id));
    }

    @Override
    public List<String> getAllRuleSetNames(String spec) throws MetadataException {
        ArrayList<String> result = new ArrayList<String>();
        DetachedCriteria criteria = DetachedCriteria.forClass(RuleSet.class);
        criteria.add((Criterion)Restrictions.eq((String)"spec", (Object)spec));
        List rsList = this.getTemplate().findByCriteria(criteria);
        for (RuleSet rs : rsList) {
            result.add(rs.getName());
        }
        return result;
    }

    @Override
    public RuleSet getRuleSet(long id) throws SearchException {
        RuleSet rs = (RuleSet)this.getTemplate().get(RuleSet.class, (Serializable)Long.valueOf(id));
        if (rs == null) {
            throw new RuntimeException("Could not get rule set with id: " + id);
        }
        return rs;
    }

    @Override
    public RuleSet lookupRuleSet(String name, String spec) throws SearchException {
        DetachedCriteria criteria = DetachedCriteria.forClass(RuleSet.class);
        criteria.add((Criterion)Restrictions.eq((String)"spec", (Object)spec));
        criteria.add((Criterion)Restrictions.eq((String)"name", (Object)name));
        List rsList = this.getTemplate().findByCriteria(criteria);
        if (rsList == null || rsList.isEmpty()) {
            throw new RuntimeException("Could not get rule set with name: " + name);
        }
        return (RuleSet)rsList.get(0);
    }

    @Override
    public RuleSet saveRuleSet(RuleSet ruleSet) throws MetadataException {
        try {
            this.getTemplate().saveOrUpdate((Object)ruleSet);
            return ruleSet;
        }
        catch (DataAccessException e) {
            throw new MetadataException(e.getMessage(), e);
        }
    }
}

