/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.upgrade;

import com.ericsson.cms.upgrade.utils.DBUtils;
import com.ericsson.cms.upgrade.utils.UpgradeUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class UpgradeManager {
    protected static final Logger logger = Logger.getLogger(UpgradeManager.class);
    protected static final String COLUMN_NAME_SETTING_TYPE = "setting_type";
    protected static final String COLUMN_NAME_SETTING_VALUE = "setting_value";
    protected static final String SETTING_TYPE_CMS_VERSION_BEFORE_UPGRADE = "CMS_VERSION_BEFORE_UPG";
    protected static final String SQL_SELECT_VERSION_BEFORE_UPGRADE = "select setting_type, setting_value from system_settings where setting_type = 'CMS_VERSION_BEFORE_UPG'";
    protected static final String SYSTEM_PROPERTY_NAME_TMP_DIR = "java.io.tmpdir";
    protected static final String FILE_NAME_CMS_VERSION_BEFORE_UPGRADE = "cmsversionbeforeupgrade.txt";
    protected String[] argsArray;

    public UpgradeManager(String[] args) {
        this.argsArray = args;
    }

    public static void main(String[] args) throws Exception {
        logger.info((Object)"In UpgradeManager.main()...");
        UpgradeManager upgradeManager = new UpgradeManager(args);
        String versionBefore = upgradeManager.getCMSVersionBeforeUpgrade();
        logger.info((Object)("CMS Version Before Upgrade = " + versionBefore));
        String tmpDir = System.getProperty(SYSTEM_PROPERTY_NAME_TMP_DIR);
        File tmpFile = new File(tmpDir, FILE_NAME_CMS_VERSION_BEFORE_UPGRADE);
        UpgradeUtils.writeStringToFile(tmpFile, versionBefore);
    }

    public String getCMSVersionBeforeUpgrade() throws Exception {
        String versionBefore = null;
        versionBefore = this.getCMSVersionBeforeUpgradeFromDB();
        return versionBefore;
    }

    protected String getCMSVersionBeforeUpgradeFromDB() throws Exception {
        String versionBefore = null;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = DBUtils.getDBConnection(this.argsArray);
            stmt = conn.createStatement();
            String selectSQL = SQL_SELECT_VERSION_BEFORE_UPGRADE;
            logger.info((Object)("selectSQL = " + selectSQL));
            rs = stmt.executeQuery(selectSQL);
            if (rs.next() && (versionBefore = rs.getString(COLUMN_NAME_SETTING_VALUE)) != null) {
                versionBefore = versionBefore.trim();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception occurred while getting CMS version before upgrade.", (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Exception occurred while closing database ResultSet after getting CMS version before upgrade.", (Throwable)e);
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Exception occurred while closing database statement after getting CMS version before upgrade.", (Throwable)e);
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Exception occurred while closing database connection after getting CMS version before upgrade.", (Throwable)e);
            }
        }
        return versionBefore;
    }
}

