/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.metadatamanager.util;

import com.ericsson.metadatamanager.util.DocumentLoader;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldRevision;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.metadatamanager.util.XPathTranslator;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import oracle.jdbc.driver.OracleDriver;
import org.apache.log4j.Logger;

public class AssetReader {
    private static final Logger logger = Logger.getLogger(AssetReader.class);
    Connection conn;

    void setConnection(Connection conn) {
        this.conn = conn;
    }

    void closeConnection() {
        try {
            if (this.conn != null) {
                this.conn.commit();
                this.conn.close();
            }
        }
        catch (SQLException e) {
            logger.error(e);
        }
    }

    private void setFieldRevisions(Asset a) {
        String sql = "select r.revisionnumber,r.addrevision,r.deleterevision,r.ttvxpath,r.datatype,r.indices,r.largevalue,r.datevalue,r.intvalue,r.floatvalue,r.parsable,r.value,r.id from mdm_asset a, mdm_fieldrevision r where r.asset_id = a.id and r.asset_id=" + a.getId();
        a.setFieldRevisions(new ArrayList<FieldRevision>());
        try {
            PreparedStatement stmt = this.conn.prepareStatement(sql);
            ResultSet rset = stmt.executeQuery();
            while (rset.next()) {
                FieldRevision fr = this.convertToFieldRevision(rset);
                if (fr == null) continue;
                a.getFieldRevisions().add(fr);
            }
            stmt.close();
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    private FieldRevision convertToFieldRevision(ResultSet rset) throws SQLException {
        String curDataType;
        FieldRevision fr = new FieldRevision();
        String ttvPath = rset.getString(4);
        if (ttvPath == null) {
            return null;
        }
        Integer revisionNumber = rset.getInt(1);
        Integer addRevision = rset.getInt(2);
        Integer deleteRevision = rset.getInt(3);
        String dataType = rset.getString(5);
        String storedIndices = rset.getString(6);
        String dateValue = rset.getString(8);
        String intValue = rset.getString(9);
        String floatValue = rset.getString(10);
        Boolean parsable = rset.getBoolean(11);
        String stringValue = rset.getString(12);
        Long idValue = rset.getLong(13);
        if (idValue != null) {
            fr.setId(idValue);
        }
        if (revisionNumber != null) {
            fr.setRevisionNumber(revisionNumber);
        }
        if (addRevision != null) {
            fr.setAddRevision(addRevision);
        }
        if (deleteRevision != null) {
            fr.setDeleteRevision(deleteRevision);
        }
        if ((curDataType = this.getCurrentDataType(ttvPath)) == null) {
            fr.setDataType(dataType);
        } else {
            fr.setDataType(curDataType);
        }
        fr.setIndices(this.getIndices(storedIndices));
        fr.setTtvXPath(ttvPath);
        if (parsable != null) {
            fr.setParsable(parsable);
        }
        if (dateValue != null) {
            Date d = AssetReader.parseDate(dateValue);
            if (d != null) {
                fr.setTypedValue(d);
            } else {
                fr.setValue(dateValue);
            }
        } else if (intValue != null) {
            fr.setValue(intValue);
        } else if (floatValue != null) {
            fr.setValue(floatValue);
        } else if (stringValue != null) {
            fr.setValue(stringValue);
        }
        return fr;
    }

    private List<Long> getChildAssetIds(long assetId, int revisionNumber) {
        ArrayList<Long> children = new ArrayList<Long>();
        String sql = "select r.target_asset_id from mdm_asset a, mdm_relation r where (r.addrevision <= " + revisionNumber + " AND (r.deleterevision > " + revisionNumber + " OR r.deleterevision =0)) " + "and r.owning_asset_id = a.id " + "and r.owning_asset_id = " + assetId;
        try {
            PreparedStatement stmt = this.conn.prepareStatement(sql);
            ResultSet rset = stmt.executeQuery();
            while (rset.next()) {
                children.add(rset.getLong(1));
            }
            stmt.close();
        }
        catch (Exception e) {
            logger.error(e);
        }
        return children;
    }

    private Asset getAsset(long assetId, int revision) {
        String sql = "select a.id,a.class_id,a.type,a.latestrevision,a.originalasset_id,a.originalasset_revision,m.ttvxpath,m.datatype,m.indices,m.largevalue,m.datevalue,m.intvalue,m.floatvalue,m.parsable,m.value from mdm_asset a left outer join mdm_field m on a.id=m.asset_id where a.id=" + assetId;
        Asset a = null;
        try {
            PreparedStatement stmt = this.conn.prepareStatement(sql);
            ResultSet rset = stmt.executeQuery();
            boolean isFirst = true;
            while (rset.next()) {
                Field f;
                if (isFirst) {
                    a = this.convertToAsset(rset, revision);
                    isFirst = false;
                }
                if ((f = this.convertToField(rset)) == null) continue;
                a.addField(f);
            }
            stmt.close();
        }
        catch (Exception e) {
            logger.error(e);
        }
        return a;
    }

    private List<Integer> getIndices(String indices) {
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        String[] split = indices.split("#");
        boolean first = true;
        for (String index : split) {
            if (first) {
                first = false;
                continue;
            }
            try {
                indexList.add(Integer.parseInt(index));
            }
            catch (Exception e) {
                indexList.add(null);
            }
        }
        return indexList;
    }

    private Field convertToField(ResultSet rset) throws SQLException {
        Field f = new Field();
        String ttvPath = rset.getString(7);
        if (ttvPath == null) {
            return null;
        }
        String dataType = rset.getString(8);
        String storedIndices = rset.getString(9);
        String dateValue = rset.getString(11);
        String intValue = rset.getString(12);
        String floatValue = rset.getString(13);
        Boolean parsable = rset.getBoolean(14);
        String stringValue = rset.getString(15);
        String curDataType = this.getCurrentDataType(ttvPath);
        if (curDataType == null) {
            f.setDataType(dataType);
        } else {
            f.setDataType(curDataType);
        }
        f.setIndices(this.getIndices(storedIndices));
        f.setTtvXPath(ttvPath);
        if (parsable != null) {
            f.setParsable(parsable);
        }
        if (dateValue != null) {
            Date d = AssetReader.parseDate(dateValue);
            if (d != null) {
                f.setTypedValue(d);
            } else {
                f.setValue(dateValue);
            }
        } else if (intValue != null) {
            f.setValue(intValue);
        } else if (floatValue != null) {
            f.setValue(floatValue);
        } else if (stringValue != null) {
            f.setValue(stringValue);
        }
        return f;
    }

    private String getCurrentDataType(String oldXPath) {
        XPathTranslator x = new XPathTranslator();
        String ecmfXPath = x.translateTTVtoECMF(oldXPath);
        String dataType = DataTypeMappingReader.getInstance().determineDataType(ecmfXPath);
        return dataType;
    }

    private Asset convertToAsset(ResultSet rset, int revision) throws SQLException {
        Asset a = null;
        Long assetId = rset.getLong(1);
        String classId = rset.getString(2);
        String type = rset.getString(3);
        if (classId.equals("G")) {
            a = new Group(assetId);
            ((Group)a).setType(type);
        } else if (classId.equals("I")) {
            a = new Item(assetId);
            ((Item)a).setType(type);
        } else if (classId.equals("F")) {
            a = new File();
            if (assetId != null) {
                a.setId(assetId);
            }
        }
        Integer latestRevision = rset.getInt(4);
        Long originalAssetID = rset.getLong(5);
        Integer originalRevisionNumber = rset.getInt(6);
        if (latestRevision != null) {
            if (latestRevision < revision) {
                a.setLatestRevisionNumber(latestRevision);
            } else {
                a.setLatestRevisionNumber(revision);
            }
        }
        if (originalAssetID != null) {
            a.setOriginalAssetID(originalAssetID);
        }
        if (originalRevisionNumber != null) {
            a.setOriginalRevisionNumber(originalRevisionNumber);
        }
        return a;
    }

    private Asset traverseAssetTree(Asset a, int desiredRevision, boolean needToGetFieldRevision) {
        if (needToGetFieldRevision) {
            this.setFieldRevisions(a);
            this.getRightVersionOfFieldRevisions(a, desiredRevision);
            boolean forceCopyFromFieldRevisions = false;
            this.copyFromRevisionsToFields(a, desiredRevision, forceCopyFromFieldRevisions);
        }
        List<Long> childAssetIds = this.getChildAssetIds(a.getId(), desiredRevision);
        for (int i = 0; i < childAssetIds.size(); ++i) {
            Asset childAsset = this.getAsset(childAssetIds.get(i), desiredRevision);
            if (childAsset != null) {
                a.addChild(childAsset);
                this.traverseAssetTree(childAsset, desiredRevision, needToGetFieldRevision);
                continue;
            }
            logger.info(" No child asset found for assetId = " + childAssetIds.get(i));
        }
        return a;
    }

    public Asset getAssetModel(long rootAssetId, int desiredRevision, boolean isLatest) {
        Asset assetTree = null;
        Asset root = this.getAsset(rootAssetId, desiredRevision);
        if (root != null) {
            boolean toGetFieldRevision = !isLatest;
            assetTree = this.traverseAssetTree(root, desiredRevision, toGetFieldRevision);
        } else {
            System.out.println(" No Asset found for root assetId=  " + rootAssetId);
        }
        return assetTree;
    }

    private boolean needToGetFieldRevision(int desiredVersion, int assetLatestVersion) {
        boolean isGettingLatest = desiredVersion >= assetLatestVersion;
        return !isGettingLatest;
    }

    private void getRightVersionOfFieldRevisions(Asset asset, int desiredRevision) {
        HashMap<String, FieldRevision> rightVersionOfFieldRevisions = new HashMap<String, FieldRevision>();
        ArrayList<FieldRevision> invalidVersionOfFieldRevisions = new ArrayList<FieldRevision>();
        if (asset.getFieldRevisions() != null) {
            for (FieldRevision fieldRevision : asset.getFieldRevisions()) {
                int deleteRevisionNumber = fieldRevision.getDeleteRevision();
                int revisionNumber = fieldRevision.getRevisionNumber();
                String mapKey = fieldRevision.getTtvXPath() + fieldRevision.getIndices();
                FieldRevision fieldRevisionMapEntry = (FieldRevision)rightVersionOfFieldRevisions.get(mapKey);
                if (fieldRevision.getAddRevision() <= desiredRevision && (deleteRevisionNumber > desiredRevision || deleteRevisionNumber == 0) && revisionNumber <= desiredRevision) {
                    if (fieldRevisionMapEntry == null) {
                        rightVersionOfFieldRevisions.put(mapKey, fieldRevision);
                        continue;
                    }
                    if (fieldRevisionMapEntry.getRevisionNumber() < revisionNumber) {
                        invalidVersionOfFieldRevisions.add(fieldRevisionMapEntry);
                        rightVersionOfFieldRevisions.put(mapKey, fieldRevision);
                        continue;
                    }
                    invalidVersionOfFieldRevisions.add(fieldRevision);
                    continue;
                }
                invalidVersionOfFieldRevisions.add(fieldRevision);
            }
            try {
                asset.getFieldRevisions().removeAll(invalidVersionOfFieldRevisions);
            }
            catch (Exception e) {
                List<FieldRevision> frs = asset.getFieldRevisions();
                for (FieldRevision fr : invalidVersionOfFieldRevisions) {
                    System.out.println(fr.getTtvXPath() + " " + fr.getDataType() + " " + fr.getValue() + " " + fr.getIndices().toString());
                }
                for (FieldRevision fr : frs) {
                    System.out.println(fr.getTtvXPath() + " " + fr.getDataType() + " " + fr.getValue() + " " + fr.getIndices().toString());
                }
            }
        }
        asset.setFieldRevisionsMap(rightVersionOfFieldRevisions);
    }

    private void copyFromRevisionsToFields(Asset asset, int revisionNumber, boolean forceCopy) {
        List<Field> assetFields = asset.getFields();
        assetFields.removeAll(assetFields);
        for (FieldRevision fieldRevision : asset.getFieldRevisions()) {
            assetFields.add(new Field(fieldRevision));
        }
    }

    private void dumpAssetTree(Asset asset) {
        if (asset == null) {
            return;
        }
        System.out.println(asset.toString());
        for (Relation r : asset.getRelations()) {
            this.dumpAssetTree(r.getTargetAsset());
        }
    }

    private static Date parseDate(String date) {
        String format = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        ParsePosition pp = new ParsePosition(0);
        Date result = sdf.parse(date, pp);
        if (pp.getIndex() < date.length() - 1) {
            return null;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        String url = "jdbc:oracle:thin:@10.116.49.174:1521:ttv";
        String user = "wfs";
        String pwd = "Wf$1234";
        DriverManager.registerDriver((Driver)new OracleDriver());
        Connection conn = DriverManager.getConnection(url, user, pwd);
        conn.setAutoCommit(false);
        AssetReader test = new AssetReader();
        test.setConnection(conn);
        boolean isLatest = true;
        Asset assetModel = test.getAssetModel(520894L, 2, true);
        test.dumpAssetTree(assetModel);
        DocumentLoader docLoader = new DocumentLoader();
        boolean checkInvalidXpaths = true;
        System.out.println(docLoader.convertToXml(assetModel, checkInvalidXpaths));
        test.closeConnection();
    }
}

