/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.metadatamanager.util;

import com.ericsson.metadatamanager.util.AssetTreeToDocConverter;
import com.ericsson.metadatamanager.util.BadDataHandler;
import com.ericsson.metadatamanager.util.Loader;
import com.ericsson.metadatamanager.util.Upgrade_2_0_020;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.util.XPathTranslator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.jdbc.driver.OracleDriver;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class DocumentLoader {
    static final String SQL_INSERT_LATEST = "insert into mdm_metadata values (xmltype(?))";
    static final String SQL_INSERT_REVISION = "insert into mdm_metadata_revision values (xmltype(?))";
    static final String SQL_QUERY_LATEST = "select extractValue(OBJECT_VALUE,'/ECMFSpec/Package/@assetId') from mdm_metadata x where XMLEXISTS('$p/ECMFSpec[@documentId=";
    static final String SQL_QUERY_REVISION = "select extractValue(OBJECT_VALUE,'/ECMFSpec/Package/@assetId') from mdm_metadata_revision x where XMLEXISTS('$p/ECMFSpec[@documentId=";
    static boolean logInvalidXmls = false;
    static String metadata_folder = "";
    static String metadataRevision_folder = "";
    private static final Logger logger = Logger.getLogger(Loader.class);
    private XPathTranslator x = new XPathTranslator();
    private BadDataHandler handler = BadDataHandler.getInstance();

    private void convertXPaths(Asset asset, boolean checkForValidXPath) {
        if (asset == null) {
            return;
        }
        List<Field> fields = asset.getFields();
        for (Field fld : fields) {
            this.x.translateTTVtoECMF(fld);
            String val = fld.getValue();
            fld.setValue(val);
            fld = this.handler.checkAndFixSpecificField(fld);
            if (checkForValidXPath && !this.handler.isValidFieldXPath(fld.getTtvXPath())) {
                fld = this.handler.setFieldForInvalidXpath(fld);
            }
            Upgrade_2_0_020.getInstance().upgradeField(asset, fld);
        }
        for (Relation r : asset.getRelations()) {
            this.convertXPaths(r.getTargetAsset(), checkForValidXPath);
        }
    }

    private String convertToString(Document doc) {
        String xmlString = null;
        StringWriter out = new StringWriter();
        OutputFormat format = new OutputFormat(doc, null, true);
        XMLSerializer serializer = new XMLSerializer(out, format);
        try {
            serializer.serialize(doc);
            xmlString = out.toString();
        }
        catch (IOException e) {
            logger.error("Error:", e);
        }
        return xmlString;
    }

    public static void setLogInvalidXmls(boolean flag) {
        logInvalidXmls = flag;
    }

    public static boolean setXmlFolders(String latestXmlFolder, String revisionXmlFolder) {
        String[] files;
        metadata_folder = latestXmlFolder;
        metadataRevision_folder = revisionXmlFolder;
        boolean isFilesInFolder = false;
        File m_folder = new File(metadata_folder);
        File r_folder = new File(metadataRevision_folder);
        if (!m_folder.exists()) {
            m_folder.mkdir();
        } else {
            files = m_folder.list();
            if (files.length > 0) {
                isFilesInFolder = true;
                System.out.println("..There are existing files/folder in " + metadata_folder);
            }
        }
        if (!r_folder.exists()) {
            r_folder.mkdir();
        } else {
            files = r_folder.list();
            if (files.length > 0) {
                isFilesInFolder = true;
                System.out.println("..There are existing files/folder in " + metadataRevision_folder);
            }
        }
        return isFilesInFolder;
    }

    public String convertToXml(Asset rootAsset, boolean checkForValidXPath) {
        this.convertXPaths(rootAsset, checkForValidXPath);
        ArrayList<Asset> assetList = new ArrayList<Asset>();
        assetList.add(rootAsset);
        return this.convertToString(new AssetTreeToDocConverter().convert(assetList));
    }

    public int loadXmls(Connection conn, boolean isLatest, List<String> xmls) {
        String sql = isLatest ? SQL_INSERT_LATEST : SQL_INSERT_REVISION;
        Statement st = null;
        int[] count = null;
        try {
            conn.setAutoCommit(false);
            ArrayList<StringReader> srs = new ArrayList<StringReader>();
            st = conn.prepareStatement(sql);
            for (String xml : xmls) {
                StringReader r = new StringReader(xml);
                srs.add(r);
                st.setClob(1, r, xml.length());
                st.addBatch();
            }
            count = st.executeBatch();
            conn.commit();
            for (StringReader r : srs) {
                r.close();
            }
            st.close();
            return count.length;
        }
        catch (SQLException e) {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
            }
            logger.error("Error:", e);
            return 0;
        }
    }

    public int checkAndLoad(Connection conn, boolean isLatest, long docId, int revision, String xml) {
        String sql = isLatest ? SQL_QUERY_LATEST : SQL_QUERY_REVISION;
        sql = sql + docId;
        if (!isLatest) {
            sql = sql + " and @revision=";
            sql = sql + revision;
        }
        sql = sql + "]' PASSING OBJECT_VALUE as \"p\")";
        int numLoaded = 0;
        try {
            PreparedStatement stmt = conn.prepareStatement(sql);
            ResultSet rset = stmt.executeQuery();
            if (!rset.next()) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(xml);
                numLoaded = this.loadXmls(conn, isLatest, list);
            }
            stmt.close();
        }
        catch (Exception e) {
            logger.error("Error:", e);
        }
        return numLoaded;
    }

    public int checkAndLog(Connection conn, boolean isLatest, long docId, int revision) {
        String sql = isLatest ? SQL_QUERY_LATEST : SQL_QUERY_REVISION;
        sql = sql + docId;
        if (!isLatest) {
            sql = sql + " and @revision=";
            sql = sql + revision;
        }
        sql = sql + "]' PASSING OBJECT_VALUE as \"p\")";
        int numLoaded = 0;
        try {
            PreparedStatement stmt = conn.prepareStatement(sql);
            ResultSet rset = stmt.executeQuery();
            if (rset.next()) {
                numLoaded = 1;
            } else {
                logger.info("***xml missing for docId=" + docId + " revision=" + revision + " mdm_metadata=" + isLatest);
            }
            stmt.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return numLoaded;
    }

    public int isLoaded(Connection conn, boolean isLatest, long docId, int revision) {
        String sql = isLatest ? SQL_QUERY_LATEST : SQL_QUERY_REVISION;
        sql = sql + docId;
        if (!isLatest) {
            sql = sql + " and @revision=";
            sql = sql + revision;
        }
        sql = sql + "]' PASSING OBJECT_VALUE as \"p\")";
        int numLoaded = 0;
        try {
            PreparedStatement stmt = conn.prepareStatement(sql);
            ResultSet rset = stmt.executeQuery();
            if (rset.next()) {
                numLoaded = 1;
            }
            stmt.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return numLoaded;
    }

    public void logXml(boolean isLatest, long docId, int revision, String xml) {
        String xmlFile = isLatest ? metadata_folder + "/" + docId + "_" + revision + ".xml" : metadataRevision_folder + "/" + docId + "_" + revision + ".xml";
        try {
            FileWriter fstream = new FileWriter(xmlFile);
            BufferedWriter buffedOut = new BufferedWriter(fstream);
            buffedOut.write(xml);
            buffedOut.close();
        }
        catch (Exception e) {
            logger.error("Error:", e);
        }
    }

    public static void main(String[] args) throws Exception {
        String url = "jdbc:oracle:thin:@10.232.7.50:1521:WPTST3";
        String user = "wfs";
        String pwd = "Wf$1234";
        DriverManager.registerDriver((Driver)new OracleDriver());
        Connection conn = DriverManager.getConnection(url, user, pwd);
        conn.setAutoCommit(false);
        String inputFile = "C:/samples/xmls/directtv/bad_5365_1.xml";
        DocumentLoader test = new DocumentLoader();
        try {
            File file = new File(inputFile);
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(file);
            String xml = test.convertToString(doc);
            ArrayList<String> xmls = new ArrayList<String>();
            xmls.add(xml);
            test.loadXmls(conn, false, xmls);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        conn.close();
    }
}

