/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.converter.autofill;

import com.ericsson.converter.autofill.AutofillProvider;
import com.ericsson.converter.autofill.AutofillProviderRemover;
import com.ericsson.converter.autofill.AutofillProviderService;
import com.ericsson.converter.autofill.SpecParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ConvertAutofillProviders {
    private static Logger logger = Logger.getLogger(ConvertAutofillProviders.class);

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 4) {
            ConvertAutofillProviders.printHelp();
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        File file = new File(string);
        if (!file.exists()) {
            logger.error((Object)("Input folder doesn't exist: " + string));
            return;
        }
        logger.info((Object)"Starting autofill provider converter with the following parameters:");
        logger.info((Object)("Input directory  : " + string));
        logger.info((Object)("Output directory : " + string2));
        logger.info((Object)("Spec file        : " + string3));
        logger.info((Object)("Properties file  : " + string4));
        try {
            File file2 = new File(string, string3);
            if (!file2.exists()) {
                logger.error((Object)("Spec file doesn't exist: " + file2.getAbsolutePath()));
                return;
            }
            File file3 = new File(string, string4);
            if (!file3.exists()) {
                logger.error((Object)("Properties file doesn't exist: " + file3.getAbsolutePath()));
                return;
            }
            File file4 = new File(string2);
            file4.mkdirs();
            File file5 = new File(file4, string3);
            File file6 = new File(file4, string4);
            SpecParser specParser = new SpecParser(file2, file3);
            List<AutofillProvider> list = specParser.parse();
            AutofillProviderService autofillProviderService = new AutofillProviderService();
            autofillProviderService.save(list);
            ConvertAutofillProviders.removeFromSpec(file2, file5);
            ConvertAutofillProviders.removeFromProps(file3, file6, list);
        }
        catch (Exception exception) {
            logger.error((Object)"Could not convert autofill providers.", (Throwable)exception);
            return;
        }
    }

    private static void removeFromSpec(File file, File file2) throws Exception {
        logger.info((Object)("Removing autofill providers from " + file.getAbsolutePath()));
        AutofillProviderRemover.removeFromSpec(file, file2);
        logger.info((Object)("Wrote new spec to " + file2.getAbsolutePath()));
    }

    private static void removeFromProps(File file, File file2, List<AutofillProvider> list) throws Exception {
        logger.info((Object)("Removing autofill providers from " + file.getAbsolutePath()));
        Properties properties = new Properties();
        FileReader fileReader = new FileReader(file);
        properties.load(fileReader);
        ((Reader)fileReader).close();
        for (AutofillProvider autofillProvider : list) {
            properties.remove(autofillProvider.key);
        }
        FileWriter fileWriter = new FileWriter(file2);
        properties.store(fileWriter, null);
        ((Writer)fileWriter).close();
        logger.info((Object)("Wrote new properties to " + file2.getAbsolutePath()));
    }

    private static void printHelp() {
        System.out.println("Usage:");
        System.out.println("    ConvertAutofillProviders <inputDir> <outputDir> <inputSpecFile> <inputPropertiesFile>");
        System.out.println("where");
        System.out.println("    <inputDir>            - Input folder with definition.xml and properties files.");
        System.out.println("                            For example: /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.cablelabsvod11.ui/resources");
        System.out.println("    <outputDir>           - Output folder for new definition.xml");
        System.out.println("    <inputSpecFile>       - Name of the specification file. Usually it is definition.xml");
        System.out.println("    <inputPropertiesFile> - Name of the properties file. Usually it is ecmf.properties");
    }
}

