/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass;

import com.tandbergtv.content.contentclass.ContentClassBuilder;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.hibernate.ContentClassServiceHibernate;
import com.tandbergtv.content.contentclass.util.HibernateContext;
import com.tandbergtv.content.contentclass.util.HibernateUtil;
import com.tandbergtv.content.contentclass.util.SpecUtil;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.Specification;
import java.util.List;
import org.apache.log4j.Logger;

public class ContentClassConverterDb {
    private static final String CONTENT_CLASS_VERSION = "2.5";
    private static Logger logger = Logger.getLogger(ContentClassConverterDb.class);
    private String specPath;
    private ContentClassServiceHibernate service;
    private Specification spec;
    private ContentClassBuilder ccBuilder;

    public ContentClassConverterDb(String string) {
        this.specPath = string;
    }

    public void run() throws Exception {
        this.loadSpecification(this.specPath);
        HibernateUtil.initHibernate();
        this.service = new ContentClassServiceHibernate();
        this.convertContentClasses();
        HibernateUtil.closeHibernate();
    }

    private List<ContentClass> getAllContentClasses() throws Exception {
        HibernateContext.getContext().beginTransaction();
        List<ContentClass> list = this.service.getAllContentClassesWithoutMetadata();
        HibernateContext.getContext().commitTransaction();
        return list;
    }

    public void convertContentClasses() {
        logger.info((Object)"Converting Content Classes");
        List<ContentClass> list = null;
        try {
            list = this.getAllContentClasses();
        }
        catch (Exception exception) {
            logger.error((Object)"Could not read list of content classes", (Throwable)exception);
            return;
        }
        if (list == null) {
            logger.info((Object)"There are no content classes to convert");
            return;
        }
        for (ContentClass contentClass : list) {
            try {
                this.convertContentClass(contentClass.getId());
            }
            catch (Exception exception) {
                logger.info((Object)("Could not convert content class with ID = " + contentClass.getId()), (Throwable)exception);
            }
        }
    }

    private void convertContentClass(long l) throws Exception {
        ContentClass contentClass = this.loadContentClass(l);
        if (contentClass == null || contentClass.getMetadata() == null) {
            return;
        }
        if (CONTENT_CLASS_VERSION.equals(contentClass.getMetadata().getVersion())) {
            logger.info((Object)("Skipping content class: id = " + l + ", name = " + contentClass.getName() + ". It is already at version " + CONTENT_CLASS_VERSION));
            return;
        }
        logger.info((Object)("Converting content class: id = " + l + ", name = " + contentClass.getName()));
        ContentClass contentClass2 = this.convertContentClass(contentClass);
        this.saveContentClass(contentClass2);
        logger.info((Object)"Done.");
    }

    private ContentClass convertContentClass(ContentClass contentClass) throws Exception {
        ContentClassMetadata contentClassMetadata = this.ccBuilder.convertMetadata(contentClass.getMetadata());
        contentClass.setMetadata(contentClassMetadata);
        return contentClass;
    }

    private ContentClass loadContentClass(long l) throws Exception {
        HibernateContext.getContext().beginTransaction();
        ContentClass contentClass = this.service.getContentClassById(l);
        HibernateContext.getContext().commitTransaction();
        return contentClass;
    }

    private void saveContentClass(ContentClass contentClass) throws Exception {
        HibernateContext.getContext().beginTransaction();
        this.service.saveContentClass(contentClass);
        HibernateContext.getContext().commitTransaction();
    }

    public void loadSpecification(String string) throws Exception {
        this.spec = SpecUtil.loadSpecification(string);
        this.ccBuilder = new ContentClassBuilder(this.spec);
    }
}

