/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class PropertyConverter {
    private static Logger logger = Logger.getLogger(PropertyConverter.class);
    private String inFileName;
    private String outFileName;
    private String templateFileName;
    private String inFolder;
    private String outFolder;
    private Map<Object, Object> map;

    public Map<Object, Object> getProperties() {
        return this.map;
    }

    public void process() throws Exception {
        Serializable serializable;
        File file;
        logger.info((Object)"Merging old properties...");
        File file2 = new File(this.inFolder, this.inFileName);
        String string = file2.getAbsolutePath();
        if (this.outFolder == null) {
            file = new File(this.outFileName);
        } else {
            serializable = new File(this.outFolder);
            if (!serializable.exists()) {
                serializable.mkdirs();
            }
            file = new File((File)serializable, this.outFileName);
        }
        logger.info((Object)("Loading old properties from " + string));
        serializable = this.loadOldProperties(string);
        logger.info((Object)"done");
        Properties properties = this.loadDefaultProperties(this.templateFileName);
        this.map = new TreeMap<Object, Object>();
        this.map.putAll(properties);
        this.map.putAll((Map<Object, Object>)((Object)serializable));
        logger.info((Object)("Writing merged properties to " + file.getAbsolutePath()));
        this.writeProperties(this.map, file);
        logger.info((Object)"done");
    }

    private void writeProperties(Map<Object, Object> map, File file) throws Exception {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write("# Autogenerated");
        bufferedWriter.newLine();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            bufferedWriter.write(entry.getKey() + "=" + entry.getValue());
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
    }

    private Properties loadOldProperties(String string) throws Exception {
        Properties properties = new Properties();
        properties.load(new FileReader(string));
        return properties;
    }

    private Properties loadDefaultProperties(String string) throws Exception {
        logger.info((Object)("Loading default properties " + string + " from resources folder"));
        InputStream inputStream = PropertyConverter.class.getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            throw new Exception("Could not load " + string + " template from resources folder.");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        Properties properties = new Properties();
        properties.load(bufferedReader);
        logger.info((Object)"done");
        return properties;
    }

    public void setInFileName(String string) {
        this.inFileName = string;
    }

    public void setOutFileName(String string) {
        this.outFileName = string;
    }

    public void setTemplateFileName(String string) {
        this.templateFileName = string;
    }

    public void setInFolder(String string) {
        this.inFolder = string;
    }

    public void setOutFolder(String string) {
        this.outFolder = string;
    }
}

