/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass;

import com.tandbergtv.content.contentclass.spec.FlatAsset;
import com.tandbergtv.content.contentclass.spec.FlatSpec;
import com.tandbergtv.content.contentclass.util.XPathTranslator;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.ComplexVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.SimpleVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.StringVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.TitleType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.VariableType;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class SpecAttributeHandler {
    private static Logger logger = Logger.getLogger(SpecAttributeHandler.class);
    private FlatSpec oldSpec;
    private Specification newSpec;
    private FlatAsset currentOldAsset;

    public SpecAttributeHandler(FlatSpec flatSpec, Specification specification) throws Exception {
        this.oldSpec = flatSpec;
        this.newSpec = specification;
    }

    public void run() throws Exception {
        TitleType titleType = this.newSpec.getTitle();
        this.walkTitleTree(titleType, null);
    }

    private void walkTitleTree(TitleType titleType, String string) throws Exception {
        String string2 = titleType.getName();
        String string3 = string == null ? string2 : string + "/" + string2;
        this.processTitle(titleType, string3);
        if (titleType.getChildTitles() == null) {
            return;
        }
        List<TitleType> list = titleType.getChildTitles().getTitle();
        for (TitleType titleType2 : list) {
            this.walkTitleTree(titleType2, string3);
        }
    }

    private void processTitle(TitleType titleType, String string) throws Exception {
        this.currentOldAsset = this.oldSpec.findAssetByPath(string);
        if (this.currentOldAsset == null) {
            return;
        }
        titleType.setAlias(this.currentOldAsset.getTitleType().getAlias());
        List<VariableType> list = titleType.getMetadata().getVariable();
        for (VariableType variableType : list) {
            this.processVariable(variableType, "/Fields");
        }
    }

    private void processVariable(VariableType variableType, String string) throws Exception {
        String string2 = variableType.getName();
        if (variableType instanceof SimpleVariableType) {
            SimpleVariableType simpleVariableType = (SimpleVariableType)variableType;
            String string3 = simpleVariableType.isAttribute() ? string + "/@" + string2 : string + "/" + string2;
            VariableType variableType2 = this.currentOldAsset.findVariableTypeByPath(string3);
            if (variableType2 == null) {
                String string4 = XPathTranslator.instance().new2old(string3);
                variableType2 = this.currentOldAsset.findVariableTypeByPath(string4);
            }
            this.copyAttributes(variableType2, simpleVariableType);
        } else if (variableType instanceof ComplexVariableType) {
            Object object;
            ComplexVariableType complexVariableType = (ComplexVariableType)variableType;
            String string5 = string + "/" + string2;
            VariableType variableType3 = this.currentOldAsset.findVariableTypeByPath(string5);
            if (variableType3 == null) {
                object = XPathTranslator.instance().new2old(string5);
                variableType3 = this.currentOldAsset.findVariableTypeByPath((String)object);
            }
            this.copyAttributes(variableType3, complexVariableType);
            object = complexVariableType.getVariable();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                VariableType variableType4 = (VariableType)iterator.next();
                this.processVariable(variableType4, string5);
            }
        }
    }

    private void copyAttributes(VariableType variableType, VariableType variableType2) {
        if (variableType == null || variableType2 == null) {
            return;
        }
        variableType2.setDisplayName(variableType.getDisplayName());
        Boolean bl = variableType.isShowCollapsed();
        variableType2.setShowCollapsed(bl == null || bl == false ? null : Boolean.valueOf(true));
        if (variableType instanceof SimpleVariableType && variableType2 instanceof SimpleVariableType) {
            SimpleVariableType simpleVariableType = (SimpleVariableType)variableType2;
            SimpleVariableType simpleVariableType2 = (SimpleVariableType)variableType;
            bl = simpleVariableType2.isJobParameter();
            simpleVariableType.setJobParameter(bl == null || bl == false ? null : Boolean.valueOf(true));
            bl = simpleVariableType2.isJobRuleParameter();
            simpleVariableType.setJobRuleParameter(bl == null || bl == false ? null : Boolean.valueOf(true));
            if (variableType instanceof StringVariableType && variableType2 instanceof StringVariableType) {
                StringVariableType stringVariableType = (StringVariableType)variableType2;
                StringVariableType stringVariableType2 = (StringVariableType)variableType;
                stringVariableType.setLongFormat(stringVariableType2.isLongFormat());
            }
        }
    }
}

