/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.spec;

import com.tandbergtv.content.contentclass.spec.FlatAsset;
import com.tandbergtv.content.contentclass.spec.FlatSpec;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.ComplexVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.SimpleVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.TitleType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.VariableType;
import java.util.List;
import org.apache.log4j.Logger;

public class FlatSpecBuilder {
    private static Logger logger = Logger.getLogger(FlatSpecBuilder.class);
    private Specification spec;
    private FlatSpec flatSpec;

    public FlatSpecBuilder(Specification specification) {
        this.spec = specification;
    }

    public FlatSpec build() {
        this.flatSpec = new FlatSpec();
        TitleType titleType = this.spec.getTitle();
        this.walkTitleTree(titleType, null);
        return this.flatSpec;
    }

    private void walkTitleTree(TitleType titleType, String string) {
        String string2 = titleType.getName();
        String string3 = string == null ? string2 : string + "/" + string2;
        this.processTitle(titleType, string3);
        if (titleType.getChildTitles() == null) {
            return;
        }
        List<TitleType> list = titleType.getChildTitles().getTitle();
        for (TitleType titleType2 : list) {
            this.walkTitleTree(titleType2, string3);
        }
    }

    private void processTitle(TitleType titleType, String string) {
        FlatAsset flatAsset = new FlatAsset(titleType);
        this.flatSpec.addAsset(string, flatAsset);
        List<VariableType> list = titleType.getMetadata().getVariable();
        for (VariableType variableType : list) {
            this.processVariable(variableType, "/Fields", flatAsset);
        }
    }

    private void processVariable(VariableType variableType, String string, FlatAsset flatAsset) {
        String string2 = variableType.getName();
        if (variableType instanceof SimpleVariableType) {
            SimpleVariableType simpleVariableType = (SimpleVariableType)variableType;
            String string3 = simpleVariableType.isAttribute() ? string + "/@" + string2 : string + "/" + string2;
            flatAsset.addVariable(string3, simpleVariableType);
        } else if (variableType instanceof ComplexVariableType) {
            ComplexVariableType complexVariableType = (ComplexVariableType)variableType;
            String string4 = string + "/" + string2;
            flatAsset.addVariable(string4, complexVariableType);
            List<VariableType> list = complexVariableType.getVariable();
            for (VariableType variableType2 : list) {
                this.processVariable(variableType2, string4, flatAsset);
            }
        }
    }
}

