/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class XPathTranslator {
    private static Logger logger = Logger.getLogger(XPathTranslator.class);
    private static XPathTranslator instance = null;
    private Map<String, String> old2newMap = new HashMap<String, String>();
    private Map<String, String> new2oldMap = new HashMap<String, String>();

    private XPathTranslator() {
    }

    public static synchronized XPathTranslator instance() throws Exception {
        if (instance == null) {
            instance = new XPathTranslator();
            instance.init();
        }
        return instance;
    }

    private void init() throws Exception {
        String string;
        logger.info((Object)"Loading field xpath mappings from XPathMapping.dat");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(XPathTranslator.class.getClassLoader().getResourceAsStream("XPathMapping.dat")));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.startsWith("#") || string.indexOf(",") == -1) continue;
            String[] stringArray = string.split(",");
            String string2 = stringArray[0].trim();
            String string3 = stringArray[1].trim();
            this.old2newMap.put(string2, string3);
            this.new2oldMap.put(string3, string2);
        }
        bufferedReader.close();
        logger.info((Object)"Loaded field xpath mappings");
    }

    public String old2new(String string) {
        String string2 = string.startsWith("/Fields") ? string : "/Fields" + string;
        String string3 = this.old2newMap.get(string2);
        if (string3 == null) {
            string3 = string2;
        }
        if (string3.startsWith("/Fields/CustomFields") && string3.endsWith("/value")) {
            string3 = string3.replace("/value", "/@value");
        }
        return string3;
    }

    public String new2old(String string) {
        String string2 = this.new2oldMap.get(string);
        return string2 == null ? string : string2;
    }

    public boolean containsOldPath(String string) {
        return this.old2newMap.containsKey(string);
    }

    public boolean containsNewPath(String string) {
        return this.new2oldMap.containsKey(string);
    }
}

