/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.watchpoint.pmm.title.conf.ComplexVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class TitleConf {
    private UISpecification specification;
    private String name;
    private String alias;
    private String path;
    private int maxOccurs;
    private TitleConf parent;
    private List<TitleConf> children = new ArrayList<TitleConf>();
    private List<Variable> metadata = new ArrayList<Variable>();

    public TitleConf(UISpecification uISpecification) {
        this.specification = uISpecification;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMaxOccurs(int n) {
        this.maxOccurs = n;
    }

    public String getAlias() {
        if (this.alias == null || this.alias.length() == 0) {
            return this.name;
        }
        ResourceBundle resourceBundle = this.specification.getBundle();
        if (resourceBundle != null && resourceBundle.containsKey(this.alias)) {
            return resourceBundle.getString(this.alias);
        }
        return this.alias;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public UISpecification getSpecification() {
        return this.specification;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public TitleConf getParent() {
        return this.parent;
    }

    public void setParent(TitleConf titleConf) {
        this.parent = titleConf;
    }

    public String getParentName() {
        return this.parent != null ? this.parent.getName() : null;
    }

    public List<TitleConf> getChildren() {
        return this.children;
    }

    public void setChildren(List<TitleConf> arrayList) {
        if (arrayList != null) {
            for (TitleConf titleConf : arrayList) {
                titleConf.setParent(this);
            }
        }
        this.children = arrayList != null ? arrayList : new ArrayList();
    }

    public List<Variable> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(List<Variable> arrayList) {
        this.metadata = arrayList != null ? arrayList : new ArrayList();
    }

    public Variable getMetadataVariableByXPath(String string) {
        return this.getMetadataVariableByXPath(this.metadata, string);
    }

    private Variable getMetadataVariableByXPath(List<Variable> list, String string) {
        if (list == null) {
            return null;
        }
        Variable variable = null;
        for (Variable variable2 : list) {
            if (string.equals(variable2.getXPath())) {
                variable = variable2;
            } else if (variable2 instanceof ComplexVariable) {
                ComplexVariable complexVariable = (ComplexVariable)variable2;
                variable = this.getMetadataVariableByXPath(complexVariable.getChildren(), string);
            }
            if (variable == null) continue;
            break;
        }
        return variable;
    }

    public TitleConf getChild(String string) {
        if (this.children != null) {
            for (TitleConf titleConf : this.children) {
                if (!titleConf.getName().equals(string)) continue;
                return titleConf;
            }
        }
        return null;
    }

    public void addChild(TitleConf titleConf) {
        titleConf.setParent(this);
        this.children.add(titleConf);
    }

    public void addMetadata(Variable variable) {
        this.metadata.add(variable);
    }

    public List<TitleConf> getAllDescendants() {
        ArrayList<TitleConf> arrayList = new ArrayList<TitleConf>();
        for (TitleConf titleConf : this.getChildren()) {
            arrayList.add(titleConf);
            arrayList.addAll(titleConf.getAllDescendants());
        }
        return arrayList;
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : super.hashCode();
    }

    public boolean equals(Object object) {
        if (this.name != null) {
            return object instanceof TitleConf && this.name.equals(((TitleConf)object).name);
        }
        return super.equals(object);
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TitleConf:\n");
        stringBuffer.append("Name: " + this.name).append(" (").append(this.getAlias()).append(")").append(string);
        stringBuffer.append("Parent Name: " + this.getParentName()).append(string);
        stringBuffer.append("Metadata: \n");
        for (Variable object : this.metadata) {
            stringBuffer.append(object).append(string);
        }
        stringBuffer.append("Children: \n");
        for (TitleConf titleConf : this.children) {
            stringBuffer.append(titleConf).append(string);
        }
        return stringBuffer.toString();
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }
}

