/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.customfield.persistence;

import com.tandbergtv.metadatamanager.customfield.CustomFieldDeleteCallbackException;
import com.tandbergtv.metadatamanager.customfield.ICustomFieldDeleteCallback;
import com.tandbergtv.metadatamanager.customfield.model.CustomField;
import com.tandbergtv.metadatamanager.customfield.model.CustomFieldGroup;
import com.tandbergtv.metadatamanager.customfield.persistence.ICustomFieldPersistenceService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.springframework.context.ApplicationContext;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class CustomFieldPersistenceService
implements ICustomFieldPersistenceService {
    private static Logger logger = Logger.getLogger(CustomFieldPersistenceService.class);
    private HibernateTemplate template;
    private PlatformTransactionManager platformTxMgr;
    private static ICustomFieldPersistenceService instance;

    public PlatformTransactionManager getPlatformTxMgr() {
        return this.platformTxMgr;
    }

    public void setPlatformTxMgr(PlatformTransactionManager platformTxMgr) {
        this.platformTxMgr = platformTxMgr;
    }

    public void setTemplate(HibernateTemplate template) {
        this.template = template;
    }

    public static synchronized ICustomFieldPersistenceService getInstance(ApplicationContext context) {
        if (instance == null) {
            instance = (ICustomFieldPersistenceService)context.getBean("customFieldPersistenceService");
        }
        return instance;
    }

    @Override
    @Transactional
    public List<CustomFieldGroup> getAllGroups() {
        List groupList = null;
        Session session = this.getCurrentSession();
        SQLQuery query = session.createSQLQuery("select * from mdm_custom_field_group order by createdate").addEntity(CustomFieldGroup.class);
        groupList = query.list();
        return groupList;
    }

    @Override
    @Transactional
    public Map<String, List<CustomFieldGroup>> getAllGroupsPerAsset() {
        List<CustomFieldGroup> groups = this.getAllGroups();
        HashMap<String, List<CustomFieldGroup>> map = new HashMap<String, List<CustomFieldGroup>>();
        if (groups != null) {
            for (CustomFieldGroup group : groups) {
                String path = group.getAssetPath();
                ArrayList<CustomFieldGroup> list = (ArrayList<CustomFieldGroup>)map.get(path);
                if (list == null) {
                    list = new ArrayList<CustomFieldGroup>();
                    map.put(path, list);
                }
                list.add(group);
            }
        }
        return map;
    }

    @Override
    public Session getCurrentSession() {
        return (Session)this.getTemplate().executeWithNativeSession(new HibernateCallback(){

            public Session doInHibernate(Session session) {
                return session;
            }
        });
    }

    public HibernateTemplate getTemplate() {
        return this.template;
    }

    public static ICustomFieldPersistenceService getInstance() {
        return instance;
    }

    @Override
    @Transactional
    public void saveGroups(List<CustomFieldGroup> groupList) throws CustomFieldDeleteCallbackException {
        Session session = this.getCurrentSession();
        try {
            for (CustomFieldGroup group : groupList) {
                if (group.getId() != null) {
                    CustomFieldGroup oldGroup = (CustomFieldGroup)session.get(CustomFieldGroup.class, (Serializable)group.getId());
                    List<CustomField> deleteFields = this.getDeletedFields(oldGroup.getCustomFieldList(), group.getCustomFieldList());
                    this.deleteFields(deleteFields, session);
                    this.updateGroup(group, oldGroup, session);
                    session.saveOrUpdate((Object)oldGroup);
                    continue;
                }
                session.saveOrUpdate((Object)group);
            }
        }
        catch (CustomFieldDeleteCallbackException e) {
            logger.error((Object)("Could not save custom field groups: " + e));
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)("Could not save custom field groups: " + e));
        }
    }

    private void deleteFields(List<CustomField> deleteFields, Session session) throws CustomFieldDeleteCallbackException {
        if (deleteFields != null) {
            try {
                for (CustomField field : deleteFields) {
                    ServiceLoader<ICustomFieldDeleteCallback> loader = ServiceLoader.load(ICustomFieldDeleteCallback.class);
                    Iterator<ICustomFieldDeleteCallback> serviceIterator = loader.iterator();
                    while (serviceIterator != null && serviceIterator.hasNext()) {
                        serviceIterator.next().beforeCustomFieldDelete(field);
                    }
                    Query query = session.createSQLQuery("delete from mdm_custom_field where custom_field_id = ?").addEntity(CustomField.class).setLong(0, field.getId().longValue());
                    query.executeUpdate();
                    Iterator<ICustomFieldDeleteCallback> iter = loader.iterator();
                    while (iter != null && iter.hasNext()) {
                        iter.next().afterCustomFieldDelete(field);
                    }
                }
            }
            catch (CustomFieldDeleteCallbackException e) {
                logger.error((Object)("Could not delete custom field group: " + e));
                throw e;
            }
        }
    }

    private void updateGroup(CustomFieldGroup group, CustomFieldGroup oldGroup, Session session) {
        oldGroup.setDisplayName(group.getDisplayName());
        if (group.getCustomFieldList() != null && (oldGroup.getCustomFieldList() == null || oldGroup.getCustomFieldList().isEmpty())) {
            oldGroup.setCustomFieldList(group.getCustomFieldList());
        } else if (group.getCustomFieldList() != null) {
            for (CustomField field : group.getCustomFieldList()) {
                if (field.getId() != null) {
                    this.updateExistingField(oldGroup, field);
                    continue;
                }
                oldGroup.getCustomFieldList().size();
                oldGroup.getCustomFieldList().add(field);
                session.save((Object)field);
                session.merge((Object)oldGroup);
            }
        }
    }

    private void updateExistingFieldFromImport(CustomFieldGroup oldGroup, CustomField field) {
        for (CustomField oldField : oldGroup.getCustomFieldList()) {
            if (!oldField.getName().equalsIgnoreCase(field.getName())) continue;
            oldField.setDisplayName(field.getDisplayName());
            oldField.setFieldType(field.getFieldType());
            oldField.setJobParameter(field.getJobParameter());
            oldField.setMultiValue(field.getMultiValue());
            oldField.setJobScheduleParameter(field.getJobScheduleParameter());
        }
    }

    private List<CustomField> getDeletedFields(List<CustomField> oldList, List<CustomField> customFieldList) {
        ArrayList<CustomField> deleteList = new ArrayList<CustomField>();
        if (oldList != null) {
            for (CustomField oldField : oldList) {
                if (customFieldList != null) {
                    if (customFieldList.contains(oldField)) continue;
                    deleteList.add(oldField);
                    continue;
                }
                deleteList.add(oldField);
            }
        }
        return deleteList;
    }

    private void updateExistingField(CustomFieldGroup oldGroup, CustomField field) {
        for (CustomField oldField : oldGroup.getCustomFieldList()) {
            if (oldField.getId().longValue() != field.getId().longValue()) continue;
            oldField.setName(field.getName());
            oldField.setDisplayName(field.getDisplayName());
            oldField.setFieldType(field.getFieldType());
            oldField.setJobParameter(field.getJobParameter());
            oldField.setMultiValue(field.getMultiValue());
            oldField.setJobScheduleParameter(field.getJobScheduleParameter());
        }
    }

    @Override
    @Transactional
    public boolean validField(String name, String displayName, String path, String groupDisplayname) {
        Session session = this.getCurrentSession();
        Query query = session.createSQLQuery("select * from mdm_custom_field where name = ?").addEntity(CustomField.class).setString(0, name);
        List list = query.list();
        if (list != null && !list.isEmpty()) {
            for (CustomField field : list) {
                if (!field.getGroup().getAssetPath().equalsIgnoreCase(path) || !field.getGroup().getDisplayName().equalsIgnoreCase(groupDisplayname) || !field.getDisplayName().equalsIgnoreCase(displayName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Transactional
    public void deleteCustomField(CustomField field) {
        Session session = this.getCurrentSession();
        try {
            CustomField customField = (CustomField)session.get(CustomField.class, (Serializable)field.getId());
            session.delete((Object)customField);
        }
        catch (Exception e) {
            logger.error((Object)("Could not delete custom field: " + e));
        }
    }

    @Override
    @Transactional
    public void deleteCustomFieldGroup(CustomFieldGroup group) {
        Session session = this.getCurrentSession();
        try {
            CustomFieldGroup oldGroup = (CustomFieldGroup)session.get(CustomFieldGroup.class, (Serializable)group.getId());
            session.delete((Object)oldGroup);
        }
        catch (Exception e) {
            logger.error((Object)("Could not delete custom field group: " + e));
        }
    }

    @Override
    @Transactional
    public void deleteCustomFieldGroups(List<CustomFieldGroup> deletedGroups) throws CustomFieldDeleteCallbackException {
        Session session = this.getCurrentSession();
        ServiceLoader<ICustomFieldDeleteCallback> loader = ServiceLoader.load(ICustomFieldDeleteCallback.class);
        for (CustomFieldGroup group : deletedGroups) {
            try {
                CustomFieldGroup oldGroup = (CustomFieldGroup)session.get(CustomFieldGroup.class, (Serializable)group.getId());
                List<CustomField> fieldList = oldGroup.getCustomFieldList();
                if (fieldList != null) {
                    for (CustomField field : fieldList) {
                        Iterator<ICustomFieldDeleteCallback> serviceIterator = loader.iterator();
                        while (serviceIterator != null && serviceIterator.hasNext()) {
                            serviceIterator.next().beforeCustomFieldDelete(field);
                        }
                        Query query = session.createSQLQuery("delete from mdm_custom_field where custom_field_id = ?").addEntity(CustomField.class).setLong(0, field.getId().longValue());
                        query.executeUpdate();
                        Iterator<ICustomFieldDeleteCallback> iter = loader.iterator();
                        while (iter != null && iter.hasNext()) {
                            iter.next().afterCustomFieldDelete(field);
                        }
                    }
                }
                Query query = session.createSQLQuery("delete from mdm_custom_field_group where group_id = ?").addEntity(CustomFieldGroup.class).setLong(0, group.getId().longValue());
                query.executeUpdate();
                Iterator<ICustomFieldDeleteCallback> iter2 = loader.iterator();
                while (iter2 != null && iter2.hasNext()) {
                    iter2.next().afterCustomFieldGroupDelete(group);
                }
            }
            catch (CustomFieldDeleteCallbackException e) {
                logger.error((Object)("Could not delete custom field group: " + e));
                throw e;
            }
            catch (Exception e) {
                logger.error((Object)("Could not delete custom field group: " + e));
                throw new CustomFieldDeleteCallbackException("Exception on delete custom field: " + e.getMessage());
            }
        }
    }

    @Override
    @Transactional
    public void saveImportedCustomFields(List<CustomFieldGroup> groupList) throws Exception {
        Session session = this.getCurrentSession();
        try {
            for (CustomFieldGroup group : groupList) {
                if (group.getUuid() != null) {
                    Query query = session.createSQLQuery("select * from mdm_custom_field_group where uuid = ?").addEntity(CustomFieldGroup.class).setString(0, group.getUuid());
                    CustomFieldGroup oldGroup = (CustomFieldGroup)query.uniqueResult();
                    if (oldGroup != null) {
                        this.updateImportedGroup(group, oldGroup, session);
                        session.saveOrUpdate((Object)oldGroup);
                        continue;
                    }
                    session.saveOrUpdate((Object)group);
                    continue;
                }
                session.saveOrUpdate((Object)group);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Could not import/save custom field groups: " + e));
            throw e;
        }
    }

    private void updateImportedGroup(CustomFieldGroup group, CustomFieldGroup oldGroup, Session session) {
        oldGroup.setDisplayName(group.getDisplayName());
        if (group.getCustomFieldList() != null && (oldGroup.getCustomFieldList() == null || oldGroup.getCustomFieldList().isEmpty())) {
            oldGroup.setCustomFieldList(group.getCustomFieldList());
        } else if (group.getCustomFieldList() != null) {
            for (CustomField field : group.getCustomFieldList()) {
                if (this.fieldExists(field.getName(), group.getAssetPath(), group.getDisplayName())) {
                    this.updateExistingFieldFromImport(oldGroup, field);
                    continue;
                }
                oldGroup.getCustomFieldList().size();
                oldGroup.getCustomFieldList().add(field);
                session.save((Object)field);
                session.merge((Object)oldGroup);
            }
        }
    }

    private boolean fieldExists(String name, String assetPath, String groupDisplayName) {
        Session session = this.getCurrentSession();
        Query query = session.createSQLQuery("select * from mdm_custom_field where name = ?").addEntity(CustomField.class).setString(0, name);
        List list = query.list();
        if (list != null && !list.isEmpty()) {
            for (CustomField field : list) {
                if (!field.getGroup().getAssetPath().equalsIgnoreCase(assetPath) || !field.getGroup().getDisplayName().equalsIgnoreCase(groupDisplayName)) continue;
                return true;
            }
        }
        return false;
    }
}

