/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import com.ericsson.cms.criteria.ExpNode;
import com.tandbergtv.metadatamanager.DocumentDAOHelper;
import com.tandbergtv.metadatamanager.search.AssetSearchQueryBuilder;
import com.tandbergtv.metadatamanager.search.AssetSearchService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.classic.Session;
import org.hibernate.jdbc.Work;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Document;

public class AssetSearchServiceImpl
implements AssetSearchService {
    private HibernateTemplate hibernateTemplate;
    private static AssetSearchQueryBuilder asqb = new AssetSearchQueryBuilder();
    private static final Logger logger = Logger.getLogger(AssetSearchServiceImpl.class);

    public HibernateTemplate getHibernateTemplate() {
        return this.hibernateTemplate;
    }

    public void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
        this.hibernateTemplate = hibernateTemplate;
    }

    private List<Long> executeQuery(final String queryStr) {
        final ArrayList<Long> ids = new ArrayList<Long>();
        Work work = new Work(){

            public void execute(Connection conn) throws SQLException {
                PreparedStatement statement = conn.prepareStatement(queryStr);
                ResultSet results = statement.executeQuery();
                while (results.next()) {
                    ids.add(results.getLong(1));
                }
            }
        };
        this.doWork(work);
        return ids;
    }

    private void doWork(Work work) {
        Session session = this.hibernateTemplate.getSessionFactory().openSession();
        try {
            session.doWork(work);
        }
        catch (RuntimeException e) {
            try {
                session.cancelQuery();
            }
            catch (Exception e1) {
                // empty catch block
            }
            throw e;
        }
        session.close();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public List<Document> search(ExpNode condition, boolean onlyOriginals) {
        String query = asqb.buildQueryForFullDoc(condition, onlyOriginals);
        logger.debug((Object)query);
        Session session = this.hibernateTemplate.getSessionFactory().getCurrentSession();
        return DocumentDAOHelper.getDocuments((org.hibernate.Session)session, query);
    }

    @Override
    public Collection<Long> searchForDocId(ExpNode condition, boolean onlyOriginals) {
        String query = asqb.buildQuery(condition, onlyOriginals, null);
        logger.debug((Object)query);
        return this.executeQuery(query);
    }

    @Override
    public Collection<Long> searchForDocId(ExpNode condition, boolean onlyOriginals, ExpNode generalConditions) {
        String query = asqb.buildQuery(condition, onlyOriginals, generalConditions);
        logger.info((Object)("searchForDocId:" + query));
        return this.executeQuery(query);
    }

    @Override
    @Transactional
    public List<String> getFieldValuesFromForRevision(String path, Long documentId) {
        return this.getFieldValuesHelper(path, documentId, "mdm_metadata_revision");
    }

    @Override
    @Transactional
    public List<String> getFieldValues(String fieldXpath, Long documentId) {
        return this.getFieldValuesHelper(fieldXpath, documentId, "mdm_metadata");
    }

    private List<String> getFieldValuesHelper(String path, Long documentId, String tableName) {
        StringBuffer query = new StringBuffer("select value from ");
        query.append(tableName);
        query.append(" mdm,\txmltable('for $i in /");
        query.append(path);
        query.append(" \r\nreturn <ROW><value>{$i}</value></ROW>'");
        query.append("passing sys_nc_rowinfo$ ");
        query.append("columns value varchar(2000) path '/ROW/value')  xtab ");
        query.append("where xmlexists('$p/ECMFSpec[@documentId = ");
        query.append(documentId);
        query.append(" ]' passing sys_nc_rowinfo$ as \"p\")");
        final String queryStr = query.toString();
        logger.debug((Object)queryStr);
        final ArrayList<String> results = new ArrayList<String>();
        Work work = new Work(){

            public void execute(Connection conn) throws SQLException {
                PreparedStatement statement = conn.prepareStatement(queryStr);
                ResultSet resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    results.add(resultSet.getString(1));
                }
            }
        };
        this.doWork(work);
        return results;
    }
}

