/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.util;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginRegistry;

public class CompatibilityInfo {
    private static final String PARAMETER_ID = "ttvBinderVersion";
    private static final String EXTENSION_ID = "compatibility";
    private static final String PLUGIN_ID = "com.tandbergtv.metadata";
    private static CompatibilityInfo instance = null;
    String ttvBinderVersion;
    private static final Logger logger = Logger.getLogger(CompatibilityInfo.class);

    public static synchronized CompatibilityInfo getInstance(PluginManager pm) {
        if (instance == null) {
            instance = new CompatibilityInfo(pm);
        }
        return instance;
    }

    public static CompatibilityInfo getInstance() {
        return CompatibilityInfo.getInstance(null);
    }

    private CompatibilityInfo(PluginManager pm) {
        if (pm != null) {
            try {
                PluginRegistry pluginRegistry = pm.getRegistry();
                ExtensionPoint point = pluginRegistry.getExtensionPoint(PLUGIN_ID, EXTENSION_ID);
                Collection extensions = point.getAvailableExtensions();
                if (!extensions.isEmpty()) {
                    Extension extension = (Extension)extensions.iterator().next();
                    Extension.Parameter param = extension.getParameter(PARAMETER_ID);
                    if (param != null) {
                        this.ttvBinderVersion = param.valueAsString();
                    } else {
                        logger.warn((Object)"ttvBinderVersion not defined in your com.tandbergtv.metadata plugin. Defaulting to 1.5");
                        this.ttvBinderVersion = "1.5";
                    }
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Error reading ttvBinderVersion parameter in com.tandbergtv.metadata plugin", (Throwable)e);
            }
        }
    }

    public String getTtvBinderVersion() {
        return this.ttvBinderVersion;
    }
}

