/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.metadatamanager.ITTVDataModelHandler;
import com.tandbergtv.metadatamanager.exception.InvalidRevisionException;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.exception.TranslationException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import com.tandbergtv.watchpoint.pmm.core.TitlePersistenceException;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.AssetList;
import com.tandbergtv.watchpoint.pmm.entities.IAssetList;
import com.tandbergtv.watchpoint.pmm.entities.ProgressItem;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;

public class DefaultTitlePersistenceService
implements ITitlePersistenceService {
    private final ITTVDataModelHandler assetDataModelHandler;

    public DefaultTitlePersistenceService(ITTVDataModelHandler dataModelHandler) {
        this.assetDataModelHandler = dataModelHandler;
    }

    @Override
    @Transactional
    public void save(Title t) {
        Title title = t;
        DefaultTitlePersistenceService.save_aroundBody1$advice(this, title, TransactionEnforcer.aspectOf(), DefaultTitlePersistenceService.class.getDeclaredMethod("save", Title.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public void rollback(Title title, String revision) {
        Title title2 = title;
        String string = revision;
        DefaultTitlePersistenceService.rollback_aroundBody3$advice(this, title2, string, TransactionEnforcer.aspectOf(), DefaultTitlePersistenceService.class.getDeclaredMethod("rollback", Title.class, String.class).getAnnotation(Transactional.class), null);
    }

    private TitlePersistenceException buildRollbackError(Title title, String version, String errorCode, String msg, Throwable e) {
        TitlePersistenceException error = new TitlePersistenceException(errorCode, msg, e);
        error.getParameters().add(Long.toString(title.getId()));
        error.getParameters().add(version);
        error.getParameters().add(e.getLocalizedMessage());
        return error;
    }

    @Override
    @Transactional
    public Title get(Serializable id) {
        Serializable serializable = id;
        return (Title)DefaultTitlePersistenceService.get_aroundBody5$advice(this, serializable, TransactionEnforcer.aspectOf(), DefaultTitlePersistenceService.class.getDeclaredMethod("get", Serializable.class).getAnnotation(Transactional.class), null);
    }

    @Override
    public Asset getAsset(Long assetId) {
        Asset asset = null;
        try {
            asset = this.getTTVDataModelHandler().getAsset(assetId);
        }
        catch (SearchException se) {
            String msg = "Failed to get asset[" + assetId + "], error: " + se.getMessage();
            String errorCode = "TPS-002";
            TitlePersistenceException error = new TitlePersistenceException(errorCode, msg, (Throwable)se);
            error.getParameters().add(se.getLocalizedMessage());
            throw error;
        }
        return asset;
    }

    @Override
    @Transactional
    public Title get(Serializable id, String version) {
        Serializable serializable = id;
        String string = version;
        return (Title)DefaultTitlePersistenceService.get_aroundBody7$advice(this, serializable, string, TransactionEnforcer.aspectOf(), DefaultTitlePersistenceService.class.getDeclaredMethod("get", Serializable.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    @Deprecated
    public Title getWithHistory(Serializable id) {
        Serializable serializable = id;
        return (Title)DefaultTitlePersistenceService.getWithHistory_aroundBody9$advice(this, serializable, TransactionEnforcer.aspectOf(), DefaultTitlePersistenceService.class.getDeclaredMethod("getWithHistory", Serializable.class).getAnnotation(Transactional.class), null);
    }

    private Title loadTitle(Serializable id) {
        Title title = null;
        try {
            title = (Title)this.getCurrentSession().load(Title.class, id);
        }
        catch (RuntimeException e) {
            String msg = "Failed to load title[" + id + "], error: " + e.getMessage();
            String errorCode = "TPS-007";
            TitlePersistenceException error = new TitlePersistenceException(errorCode, msg, (Throwable)e);
            error.getParameters().add(String.valueOf(id));
            error.getParameters().add(e.getLocalizedMessage());
            throw error;
        }
        return title;
    }

    @Override
    @Transactional
    public Title getTitleForUpdate(Serializable id) {
        Serializable serializable = id;
        return (Title)DefaultTitlePersistenceService.getTitleForUpdate_aroundBody11$advice(this, serializable, TransactionEnforcer.aspectOf(), DefaultTitlePersistenceService.class.getDeclaredMethod("getTitleForUpdate", Serializable.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public synchronized boolean delete(Serializable id) {
        Serializable serializable = id;
        return Conversions.booleanValue((Object)DefaultTitlePersistenceService.delete_aroundBody13$advice(this, serializable, TransactionEnforcer.aspectOf(), DefaultTitlePersistenceService.class.getDeclaredMethod("delete", Serializable.class).getAnnotation(Transactional.class), null));
    }

    @Override
    @Transactional
    public Title retire(Title title) {
        Title title2 = title;
        return (Title)DefaultTitlePersistenceService.retire_aroundBody15$advice(this, title2, TransactionEnforcer.aspectOf(), DefaultTitlePersistenceService.class.getDeclaredMethod("retire", Title.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public boolean isActiveTitle(Serializable id) {
        Serializable serializable = id;
        return Conversions.booleanValue((Object)DefaultTitlePersistenceService.isActiveTitle_aroundBody17$advice(this, serializable, TransactionEnforcer.aspectOf(), DefaultTitlePersistenceService.class.getDeclaredMethod("isActiveTitle", Serializable.class).getAnnotation(Transactional.class), null));
    }

    @Override
    @Transactional
    public boolean isExistingTitle(Serializable id) {
        Serializable serializable = id;
        return Conversions.booleanValue((Object)DefaultTitlePersistenceService.isExistingTitle_aroundBody19$advice(this, serializable, TransactionEnforcer.aspectOf(), DefaultTitlePersistenceService.class.getDeclaredMethod("isExistingTitle", Serializable.class).getAnnotation(Transactional.class), null));
    }

    @Override
    @Transactional
    public Collection<Long> getCopyIds(Serializable id) {
        Serializable serializable = id;
        return (Collection)DefaultTitlePersistenceService.getCopyIds_aroundBody21$advice(this, serializable, TransactionEnforcer.aspectOf(), DefaultTitlePersistenceService.class.getDeclaredMethod("getCopyIds", Serializable.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public Long getOriginalId(Serializable id) {
        Serializable serializable = id;
        return (Long)DefaultTitlePersistenceService.getOriginalId_aroundBody23$advice(this, serializable, TransactionEnforcer.aspectOf(), DefaultTitlePersistenceService.class.getDeclaredMethod("getOriginalId", Serializable.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public Long getIdByAssetId(long assetId) {
        long l = assetId;
        return (Long)DefaultTitlePersistenceService.getIdByAssetId_aroundBody25$advice(this, l, TransactionEnforcer.aspectOf(), DefaultTitlePersistenceService.class.getDeclaredMethod("getIdByAssetId", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public Long getPartnerId(Serializable id) {
        Serializable serializable = id;
        return (Long)DefaultTitlePersistenceService.getPartnerId_aroundBody27$advice(this, serializable, TransactionEnforcer.aspectOf(), DefaultTitlePersistenceService.class.getDeclaredMethod("getPartnerId", Serializable.class).getAnnotation(Transactional.class), null);
    }

    public String getServiceName() {
        return "Title Persistence";
    }

    public void start() {
    }

    public void stop() {
    }

    private Session getCurrentSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    private ITTVDataModelHandler getTTVDataModelHandler() {
        return this.assetDataModelHandler;
    }

    private ISpecHandler getTTVSpecHandler() {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ISpecificationManager manager = (ISpecificationManager)registry.lookup(ISpecificationManager.class);
        ISpecHandler specHandler = manager.getInternalSpecification().getSpecHandler();
        return specHandler;
    }

    private static final /* synthetic */ void save_aroundBody0(DefaultTitlePersistenceService this_, Title t) {
        try {
            boolean draft = TitleStatus.DRAFT.equals((Object)t.getStatus());
            Asset asset = this_.getTTVDataModelHandler().saveAsset(t.getAsset(), draft);
            t.setAsset(asset);
            t.getAssetStatusMap().put(asset.getVersion(), t.getStatus());
        }
        catch (MetadataException e) {
            String msg = "Failed to save title, error: " + e.getMessage();
            String errorCode = "TPS-001";
            TitlePersistenceException error = new TitlePersistenceException(errorCode, msg, (Throwable)e);
            error.getParameters().add(e.getLocalizedMessage());
            throw error;
        }
        this_.getCurrentSession().saveOrUpdate((Object)t);
    }

    private static final /* synthetic */ Object save_aroundBody1$advice(DefaultTitlePersistenceService this_, Title t, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            DefaultTitlePersistenceService.save_aroundBody0(this_, t);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            DefaultTitlePersistenceService.save_aroundBody0(this_, t);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void rollback_aroundBody2(DefaultTitlePersistenceService this_, Title title, String revision) {
        try {
            boolean draft = TitleStatus.DRAFT.equals((Object)title.getStatus());
            TTVId ttvId = title.getAsset().getTTVId();
            ISpecHandler ttvHandler = this_.getTTVSpecHandler();
            ttvHandler.rollBackToRevision(ttvId, revision);
            Asset rolledbackAsset = this_.getTTVDataModelHandler().getAsset(ttvId);
            if (draft) {
                rolledbackAsset = this_.getTTVDataModelHandler().saveAsset(rolledbackAsset, draft);
            }
            title.setAsset(rolledbackAsset);
            title.getAssetStatusMap().put(title.getAsset().getVersion(), title.getStatus());
        }
        catch (SearchException e) {
            String errorCode = "TPS-006";
            String msg = "Failed to find title[" + title.getId() + "] with revision: " + revision + " for roll back, error: " + e.getLocalizedMessage();
            throw this_.buildRollbackError(title, revision, errorCode, msg, e);
        }
        catch (InvalidRevisionException e) {
            String errorCode = "TPS-005";
            String msg = "Failed to roll back title[" + title.getId() + "] to revision: " + revision + ", error: " + e.getLocalizedMessage();
            throw this_.buildRollbackError(title, revision, errorCode, msg, e);
        }
        catch (MetadataException e) {
            String errorCode = "TPS-004";
            String msg = "Failed to roll back title[" + title.getId() + "] to revision: " + revision + ", error: " + e.getLocalizedMessage();
            throw this_.buildRollbackError(title, revision, errorCode, msg, e);
        }
        catch (TranslationException e) {
            String errorCode = "TPS-004";
            String msg = "Failed to roll back title[" + title.getId() + "] to revision: " + revision + ", error: " + e.getLocalizedMessage();
            throw this_.buildRollbackError(title, revision, errorCode, msg, e);
        }
        this_.getCurrentSession().saveOrUpdate((Object)title);
    }

    private static final /* synthetic */ Object rollback_aroundBody3$advice(DefaultTitlePersistenceService this_, Title title, String revision, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            DefaultTitlePersistenceService.rollback_aroundBody2(this_, title, revision);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            DefaultTitlePersistenceService.rollback_aroundBody2(this_, title, revision);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Title get_aroundBody4(DefaultTitlePersistenceService this_, Serializable id) {
        Title title = this_.loadTitle(id);
        TTVId ttvId = title.getAsset().getTTVId();
        try {
            Asset latestVersionAsset = this_.getTTVDataModelHandler().getDeletedAsset(ttvId, true);
            title.setAsset(latestVersionAsset);
        }
        catch (SearchException se) {
            String msg = "Failed to get title[" + id + "], error: " + se.getMessage();
            String errorCode = "TPS-003";
            TitlePersistenceException error = new TitlePersistenceException(errorCode, msg, (Throwable)se);
            error.getParameters().add(String.valueOf(id));
            error.getParameters().add(ttvId != null ? String.valueOf(ttvId.getId()) : "null");
            error.getParameters().add(se.getLocalizedMessage());
            throw error;
        }
        return title;
    }

    private static final /* synthetic */ Object get_aroundBody5$advice(DefaultTitlePersistenceService this_, Serializable id, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return DefaultTitlePersistenceService.get_aroundBody4(this_, id);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Title object = DefaultTitlePersistenceService.get_aroundBody4(this_, id);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Title get_aroundBody6(DefaultTitlePersistenceService this_, Serializable id, String version) {
        Title title = this_.loadTitle(id);
        Title copy = new Title(title);
        TTVId ttvId = title.getAsset().getTTVId();
        try {
            Asset olderVersionAsset = this_.getTTVDataModelHandler().getAsset(ttvId, version);
            copy.setAsset(olderVersionAsset);
        }
        catch (SearchException se) {
            String msg = "Failed to get title[" + id + ", version: " + version + "], error: " + se.getMessage();
            String errorCode = "TPS-002";
            TitlePersistenceException error = new TitlePersistenceException(errorCode, msg, (Throwable)se);
            error.getParameters().add(se.getLocalizedMessage());
            throw error;
        }
        return copy;
    }

    private static final /* synthetic */ Object get_aroundBody7$advice(DefaultTitlePersistenceService this_, Serializable id, String version, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return DefaultTitlePersistenceService.get_aroundBody6(this_, id, version);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Title object = DefaultTitlePersistenceService.get_aroundBody6(this_, id, version);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object getWithHistory_aroundBody9$advice(DefaultTitlePersistenceService this_, Serializable id, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return this_.get(id);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Title object = this_.get(id);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Title getTitleForUpdate_aroundBody10(DefaultTitlePersistenceService this_, Serializable id) {
        Title t = (Title)this_.getCurrentSession().load(Title.class, id, LockMode.UPGRADE);
        this_.getCurrentSession().refresh((Object)t);
        TTVId ttvId = t.getAsset().getTTVId();
        try {
            Asset latestVersionAsset = this_.getTTVDataModelHandler().getDeletedAsset(ttvId, true);
            t.setAsset(latestVersionAsset);
        }
        catch (SearchException se) {
            String msg = "Failed to get title[" + id + "], error: " + se.getMessage();
            String errorCode = "TPS-003";
            TitlePersistenceException error = new TitlePersistenceException(errorCode, msg, (Throwable)se);
            error.getParameters().add(String.valueOf(id));
            error.getParameters().add(ttvId != null ? String.valueOf(ttvId.getId()) : "null");
            error.getParameters().add(se.getLocalizedMessage());
            throw error;
        }
        return t;
    }

    private static final /* synthetic */ Object getTitleForUpdate_aroundBody11$advice(DefaultTitlePersistenceService this_, Serializable id, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return DefaultTitlePersistenceService.getTitleForUpdate_aroundBody10(this_, id);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Title object = DefaultTitlePersistenceService.getTitleForUpdate_aroundBody10(this_, id);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ boolean delete_aroundBody12(DefaultTitlePersistenceService this_, Serializable id) {
        Session session = this_.getCurrentSession();
        Title title = (Title)session.get(Title.class, id);
        if (title == null) {
            return false;
        }
        try {
            this_.getTTVDataModelHandler().delete(title.getAsset());
        }
        catch (SearchException e) {
            String msg = "Failed to delete title[" + id + "], error: " + e.getMessage();
            String errorCode = "TPS-002";
            TitlePersistenceException error = new TitlePersistenceException(errorCode, msg, (Throwable)e);
            error.getParameters().add(e.getLocalizedMessage());
            throw error;
        }
        title.setStatus(TitleStatus.DELETED);
        title.setLastModifiedTime(new Date());
        title.setIsActive(Boolean.valueOf(false));
        Collection lists = title.getTitlelists();
        for (IAssetList list : lists) {
            AssetList clone = (AssetList)session.load(AssetList.class, (Serializable)list.getId());
            clone.removeTitle(title);
            session.saveOrUpdate((Object)clone);
        }
        for (ProgressItem item : title.getProgressItems()) {
            item.setIsActive(Boolean.valueOf(false));
        }
        session.saveOrUpdate((Object)title);
        return true;
    }

    private static final /* synthetic */ Object delete_aroundBody13$advice(DefaultTitlePersistenceService this_, Serializable id, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)DefaultTitlePersistenceService.delete_aroundBody12(this_, id));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)DefaultTitlePersistenceService.delete_aroundBody12(this_, id));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Title retire_aroundBody14(DefaultTitlePersistenceService this_, Title title) {
        if (title.getIsActive().booleanValue()) {
            this_.save(title);
        } else {
            this_.getCurrentSession().saveOrUpdate((Object)title);
        }
        return title;
    }

    private static final /* synthetic */ Object retire_aroundBody15$advice(DefaultTitlePersistenceService this_, Title title, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return DefaultTitlePersistenceService.retire_aroundBody14(this_, title);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Title object = DefaultTitlePersistenceService.retire_aroundBody14(this_, title);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ boolean isActiveTitle_aroundBody16(DefaultTitlePersistenceService this_, Serializable id) {
        Query query = this_.getCurrentSession().getNamedQuery("Title.GetAssetState");
        query.setParameter("titleID", (Object)id);
        Object result = query.uniqueResult();
        return result != null && !TitleStatus.DELETED.equals(result);
    }

    private static final /* synthetic */ Object isActiveTitle_aroundBody17$advice(DefaultTitlePersistenceService this_, Serializable id, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)DefaultTitlePersistenceService.isActiveTitle_aroundBody16(this_, id));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)DefaultTitlePersistenceService.isActiveTitle_aroundBody16(this_, id));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ boolean isExistingTitle_aroundBody18(DefaultTitlePersistenceService this_, Serializable id) {
        if (id == null) {
            return false;
        }
        Query query = this_.getCurrentSession().getNamedQuery("Title.IsExistingTitle");
        query.setParameter("titleID", (Object)id);
        Long result = (Long)query.uniqueResult();
        return result != 0L;
    }

    private static final /* synthetic */ Object isExistingTitle_aroundBody19$advice(DefaultTitlePersistenceService this_, Serializable id, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)DefaultTitlePersistenceService.isExistingTitle_aroundBody18(this_, id));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)DefaultTitlePersistenceService.isExistingTitle_aroundBody18(this_, id));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Collection getCopyIds_aroundBody20(DefaultTitlePersistenceService this_, Serializable id) {
        Query query = this_.getCurrentSession().getNamedQuery("Title.GetCopyIDs");
        query.setParameter("originalTitleID", (Object)id);
        return query.list();
    }

    private static final /* synthetic */ Object getCopyIds_aroundBody21$advice(DefaultTitlePersistenceService this_, Serializable id, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return DefaultTitlePersistenceService.getCopyIds_aroundBody20(this_, id);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Collection object = DefaultTitlePersistenceService.getCopyIds_aroundBody20(this_, id);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Long getOriginalId_aroundBody22(DefaultTitlePersistenceService this_, Serializable id) {
        Query query = this_.getCurrentSession().getNamedQuery("Title.GetOriginalID");
        query.setParameter("copyTitleID", (Object)id);
        return (Long)query.uniqueResult();
    }

    private static final /* synthetic */ Object getOriginalId_aroundBody23$advice(DefaultTitlePersistenceService this_, Serializable id, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return DefaultTitlePersistenceService.getOriginalId_aroundBody22(this_, id);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Long object = DefaultTitlePersistenceService.getOriginalId_aroundBody22(this_, id);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Long getIdByAssetId_aroundBody24(DefaultTitlePersistenceService this_, long assetId) {
        Query query = this_.getCurrentSession().getNamedQuery("Title.GetIDByRootAssetID");
        query.setParameter("rootAssetID", (Object)assetId);
        return (Long)query.uniqueResult();
    }

    private static final /* synthetic */ Object getIdByAssetId_aroundBody25$advice(DefaultTitlePersistenceService this_, long assetId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return DefaultTitlePersistenceService.getIdByAssetId_aroundBody24(this_, assetId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Long object = DefaultTitlePersistenceService.getIdByAssetId_aroundBody24(this_, assetId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Long getPartnerId_aroundBody26(DefaultTitlePersistenceService this_, Serializable id) {
        Query query = this_.getCurrentSession().getNamedQuery("Title.GetPartnerID");
        query.setParameter("titleID", (Object)id);
        return (Long)query.uniqueResult();
    }

    private static final /* synthetic */ Object getPartnerId_aroundBody27$advice(DefaultTitlePersistenceService this_, Serializable id, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return DefaultTitlePersistenceService.getPartnerId_aroundBody26(this_, id);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Long object = DefaultTitlePersistenceService.getPartnerId_aroundBody26(this_, id);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

