/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.compare;

import com.tandbergtv.metadatamanager.IAssetCompareService;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.compare.IAssetCompareReport;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.compare.ITitleCompareReport;
import com.tandbergtv.watchpoint.pmm.entities.compare.TitleCompareReport;

class TitleComparator {
    private final IAssetCompareService assetCompareService;

    TitleComparator(IAssetCompareService assetCompareService) {
        this.assetCompareService = assetCompareService;
    }

    public boolean isDifferent(Title title1, Title title2) {
        Asset asset1 = title1 != null ? title1.getAsset() : null;
        Asset asset2 = title2 != null ? title2.getAsset() : null;
        return this.assetCompareService.areAssetsDifferent(asset1, asset2);
    }

    public ITitleCompareReport compare(Title title1, Title title2) {
        TitleCompareReport report = new TitleCompareReport(title1, title2);
        Asset asset1 = title1 != null ? title1.getAsset() : null;
        Asset asset2 = title2 != null ? title2.getAsset() : null;
        IAssetCompareReport assetReport = this.assetCompareService.compareAssets(asset1, asset2);
        report.setAssetCompareReport(assetReport);
        return report;
    }
}

