/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.watchpoint.pmm.title.conf.ComplexVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.OptionProviderCache;
import com.tandbergtv.watchpoint.pmm.title.conf.SimpleVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import com.tandbergtv.watchpoint.pmm.title.conf.VariableOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OptionsBuilder {
    private static Logger logger = Logger.getLogger(OptionsBuilder.class);
    private Map<String, Map<String, String>> fieldsMap = new HashMap<String, Map<String, String>>();
    private OptionProviderCache providerCache = new OptionProviderCache();

    public void addOptions(UISpecification spec) {
        if (spec == null) {
            return;
        }
        List assets = spec.getAllTitleConf();
        if (assets != null) {
            for (TitleConf asset : assets) {
                List vars = asset.getMetadata();
                if (vars == null) continue;
                for (Variable var : vars) {
                    this.addVariable(var);
                }
            }
        }
    }

    public void addOptions(Map<String, Map<String, String>> srcMap) {
        if (srcMap == null || srcMap.isEmpty()) {
            return;
        }
        for (String xpath : srcMap.keySet()) {
            Map<String, String> optionsMap = this.fieldsMap.get(xpath);
            Map<String, String> srcOptionsMap = srcMap.get(xpath);
            if (optionsMap == null || srcOptionsMap == null) continue;
            for (Map.Entry<String, String> entry : srcOptionsMap.entrySet()) {
                if (optionsMap.containsKey(entry.getKey())) continue;
                optionsMap.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private void addOptions(SimpleVariable var) {
        String xpath = var.getXPath();
        Map<String, String> options = this.fieldsMap.get(xpath);
        if (options == null) {
            options = new HashMap<String, String>();
            this.fieldsMap.put(xpath, options);
        }
        String optionProvider = var.getOptionProvider();
        List<VariableOption> varOptions = var.getOptions();
        if (varOptions == null && optionProvider != null) {
            varOptions = this.providerCache.getProviderOptions(optionProvider);
        }
        if (varOptions != null) {
            for (VariableOption vopt : varOptions) {
                if (options.containsKey(vopt.getValue())) continue;
                options.put(vopt.getValue(), vopt.getName());
            }
        }
    }

    private void addVariable(Variable variable) {
        ComplexVariable complex;
        List vars;
        if (variable == null) {
            return;
        }
        if (variable instanceof SimpleVariable) {
            SimpleVariable simple = (SimpleVariable)variable;
            if (simple.hasOptions()) {
                this.addOptions(simple);
            }
        } else if (variable instanceof ComplexVariable && (vars = (complex = (ComplexVariable)variable).getChildren()) != null) {
            for (Variable var : vars) {
                this.addVariable(var);
            }
        }
    }

    public Map<String, Map<String, String>> getFields() {
        return this.fieldsMap;
    }
}

