/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.template;

import com.tandbergtv.watchpoint.pmm.title.template.ITitleTemplateProvider;
import com.tandbergtv.watchpoint.pmm.title.template.TitleVariableProvider;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class TitleTemplateProvider
implements ITitleTemplateProvider {
    private Collection<String> variablenames;
    private static final Logger logger = Logger.getLogger(TitleTemplateProvider.class);

    public Collection<WorkflowTemplate> getTemplates() {
        ArrayList<WorkflowTemplate> templates = new ArrayList<WorkflowTemplate>();
        ITemplateLoaderService service = (ITemplateLoaderService)ServiceRegistry.getDefault().lookup(ITemplateLoaderService.class);
        if (service == null) {
            throw new RuntimeException("Don't know how to get templates");
        }
        for (WorkflowTemplate template : service.getLatestTemplates()) {
            for (TaskVariable variable : template.getStartTaskVariables()) {
                String name = variable.getVariableName();
                if (!this.variablenames.contains(name)) continue;
                templates.add(template);
            }
        }
        return templates;
    }

    public Collection<WorkflowTemplate> getTemplatesWithAnnotation(String annotationType, String annotationValue) {
        ITemplateLoaderService service = (ITemplateLoaderService)ServiceRegistry.getDefault().lookup(ITemplateLoaderService.class);
        if (service == null) {
            throw new RuntimeException("Don't know how to get templates");
        }
        ArrayList<WorkflowTemplate> templates = new ArrayList<WorkflowTemplate>();
        int avStartIndex = annotationType.length() + 3;
        for (WorkflowTemplate template : service.getLatestTemplates()) {
            Collection annotations = template.getAnnotations(annotationType);
            if (annotations == null) continue;
            for (String annotation : annotations) {
                String av;
                if (annotation == null || !(av = annotation.substring(avStartIndex, annotation.length() - 2)).equalsIgnoreCase(annotationValue)) continue;
                templates.add(template);
            }
        }
        return templates;
    }

    public String getServiceName() {
        return "Title Template Provider";
    }

    public void start() {
        this.variablenames = TitleVariableProvider.getInstance().getVariableNames();
        logger.info((Object)(this.getServiceName() + " started"));
    }

    public void stop() {
        this.variablenames = null;
    }
}

