/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass;

import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassField;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.content.contentclass.hibernate.ContentClassServiceHibernate;
import com.tandbergtv.content.contentclass.util.HibernateContext;
import com.tandbergtv.content.contentclass.util.XPathTranslator;
import com.tandbergtv.watchpoint.pmm.title.conf.ContentClassTemplate;
import com.tandbergtv.watchpoint.pmm.title.conf.FieldInfo;
import com.tandbergtv.watchpoint.pmm.title.conf.NewSpecInfo;
import com.tandbergtv.watchpoint.pmm.title.conf.NewTitleInfo;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecConverter;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecInfo;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ContentClassConverter {
    private ContentClassServiceHibernate service;
    private SpecInfo specInfo;
    private NewSpecInfo newSpecInfo;
    private ContentClassTemplate ccTemplate;

    public ContentClassConverter(SpecInfo specInfo, NewSpecInfo newSpecInfo) {
        this.specInfo = specInfo;
        this.newSpecInfo = newSpecInfo;
        this.ccTemplate = new ContentClassTemplate(specInfo);
    }

    public void init() throws Exception {
        System.out.println("Init Hibernate...");
        HibernateContext.getContext().initializeContext();
        this.service = new ContentClassServiceHibernate();
        System.out.println(" done");
    }

    public void finish() {
        HibernateContext.getContext().closeContext();
    }

    public void run() throws Exception {
        this.convertContentClasses();
        this.convertContentClassPartners();
    }

    public void convertContentClasses() throws Exception {
        System.out.println("Converting Content Classes");
        System.out.println("===================================================================");
        List<ContentClass> list = this.getAllContentClasses();
        if (list == null) {
            System.out.println("There are no content classes to convert");
            return;
        }
        for (ContentClass contentClass : list) {
            try {
                this.convertContentClass(contentClass.getId());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void convertContentClassPartners() throws Exception {
        System.out.println("\n\nConverting Content Class Partners");
        System.out.println("===================================================================");
        List<ContentClassPartner> list = this.getAllContentClassPartners();
        if (list == null) {
            System.out.println("There are no content class partners to convert");
            return;
        }
        for (ContentClassPartner contentClassPartner : list) {
            try {
                this.convertContentClassPartner(contentClassPartner);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void convertContentClassPartner(ContentClassPartner contentClassPartner) throws Exception {
        System.out.println("Converting content class partner: contentClassId = " + contentClassPartner.getContentClassId() + ", partnerId = " + contentClassPartner.getPartnerId());
        XPathTranslator xPathTranslator = XPathTranslator.instance();
        HibernateContext.getContext().beginTransaction();
        ContentClassPartner contentClassPartner2 = this.service.getContentClassPartner(contentClassPartner.getContentClassId(), contentClassPartner.getPartnerId());
        HibernateContext.getContext().commitTransaction();
        if (contentClassPartner2.getMetadata() == null) {
            return;
        }
        Collection<ContentClassAsset> collection = contentClassPartner2.getMetadata().getAssetList();
        if (collection == null || collection.isEmpty()) {
            return;
        }
        for (ContentClassAsset contentClassAsset : collection) {
            TitleInfo titleInfo = this.specInfo.findTitleByPath(contentClassAsset.getPath());
            if (titleInfo == null) {
                System.out.println("WARNING: Asset is not in old definition.xml. Skipping. " + contentClassAsset.getPath());
                continue;
            }
            NewTitleInfo newTitleInfo = this.newSpecInfo.findTitleByPath(contentClassAsset.getPath());
            if (contentClassAsset.getFieldList() == null) continue;
            ArrayList<ContentClassField> arrayList = new ArrayList<ContentClassField>(contentClassAsset.getFieldList());
            contentClassAsset.clearFields();
            for (ContentClassField contentClassField : arrayList) {
                String string;
                FieldInfo fieldInfo;
                String string2 = contentClassField.getPath();
                if (string2.endsWith("/value") && (fieldInfo = titleInfo.getFieldInfo(string = string2.replace("/value", "/@value"))) != null && fieldInfo.isAttribute) {
                    string2 = string;
                }
                string = xPathTranslator.translateContentClassPath(string2);
                contentClassField.setPath(string);
                if (newTitleInfo.isAttribute(string) || string.startsWith("/Fields/CustomFields/CustomField[")) {
                    contentClassField.setAttribute(true);
                }
                contentClassAsset.addField(contentClassField);
            }
        }
        HibernateContext.getContext().beginTransaction();
        this.service.saveContentClassPartner(contentClassPartner2);
        HibernateContext.getContext().commitTransaction();
    }

    private void convertContentClass(long l) throws Exception {
        Collection<ContentClassAsset> collection;
        HibernateContext.getContext().beginTransaction();
        ContentClass contentClass = this.service.getContentClassById(l, this.specInfo.convertingFrom2x());
        HibernateContext.getContext().commitTransaction();
        System.out.println("Converting content class: id = " + l + ", name = " + contentClass.getName());
        ContentClass contentClass2 = this.ccTemplate.createDefaultContentClass();
        contentClass2.setId(contentClass.getId());
        contentClass2.setDefault(contentClass.isDefault());
        contentClass2.setName(contentClass.getName());
        contentClass2.setDescription(contentClass.getDescription());
        contentClass2.setSpecialUsage(contentClass.getSpecialUsage());
        if (contentClass.getMetadata() != null && (collection = contentClass.getMetadata().getAssetList()) != null && !collection.isEmpty()) {
            for (ContentClassAsset contentClassAsset : collection) {
                this.convertOldAsset(contentClassAsset, contentClass2);
            }
        }
        HibernateContext.getContext().beginTransaction();
        this.service.saveContentClass(contentClass2);
        HibernateContext.getContext().commitTransaction();
    }

    private void convertOldAsset(ContentClassAsset contentClassAsset, ContentClass contentClass) {
        if (contentClassAsset.getFieldList() == null) {
            return;
        }
        XPathTranslator xPathTranslator = XPathTranslator.instance();
        ContentClassAsset contentClassAsset2 = contentClass.getMetadata().getAsset(contentClassAsset.getPath());
        if (contentClassAsset2 == null) {
            System.out.println("Invalid asset path " + contentClassAsset.getPath() + ". Skipping.");
            return;
        }
        TitleInfo titleInfo = this.specInfo.findTitleByPath(contentClassAsset.getPath());
        if (titleInfo == null) {
            System.out.println("WARNING: Asset is not in old definition.xml. Skipping. " + contentClassAsset.getPath());
            return;
        }
        if (this.specInfo.convertingFrom2x()) {
            contentClassAsset2.setMin(contentClassAsset.getMin());
            contentClassAsset2.setMax(contentClassAsset.getMax());
            contentClassAsset2.setBatchMin(contentClassAsset.getBatchMin());
            contentClassAsset2.setBatchMax(contentClassAsset.getBatchMax());
            contentClassAsset2.setDisabled(contentClassAsset.isDisabled());
            contentClassAsset2.setRequiresFile(contentClassAsset.isRequiresFile());
            contentClassAsset2.setHideFileView(contentClassAsset.isHideFileView());
        }
        NewTitleInfo newTitleInfo = this.newSpecInfo.findTitleByPath(contentClassAsset.getPath());
        for (ContentClassField contentClassField : contentClassAsset.getFieldList()) {
            String string;
            Object object;
            String string2 = contentClassField.getPath();
            if (string2.endsWith("/value") && (object = titleInfo.getFieldInfo(string = string2.replace("/value", "/@value"))) != null && ((FieldInfo)object).isAttribute) {
                string2 = string;
            }
            if ((object = contentClassAsset2.getField(string = xPathTranslator.translateContentClassPath(string2))) == null) {
                contentClassField.setPath(string);
                if (!this.specInfo.convertingFrom2x()) {
                    contentClassField.setHidden(false);
                }
                if (newTitleInfo.isAttribute(string)) {
                    contentClassField.setAttribute(true);
                }
                contentClassAsset2.addField(contentClassField);
                continue;
            }
            ((ContentClassField)object).setDefaultValue(contentClassField.getDefaultValue());
            ((ContentClassField)object).setLocked(contentClassField.isLocked());
            ((ContentClassField)object).addDisabledOptionKeys(contentClassField.getDisabledOptionKeys());
            if (!this.specInfo.convertingFrom2x()) continue;
            ((ContentClassField)object).setAutofillable(contentClassField.isAutofillable());
            ((ContentClassField)object).setAutofillProvider(contentClassField.getAutofillProvider());
            ((ContentClassField)object).setMin(contentClassField.getMin());
            ((ContentClassField)object).setMax(contentClassField.getMax());
            ((ContentClassField)object).setHidden(contentClassField.isHidden());
            ((ContentClassField)object).setIncludeInBatch(contentClassField.getIncludeInBatch());
            ((ContentClassField)object).setDisplayPattern(contentClassField.getDisplayPattern());
            ((ContentClassField)object).setOptions(contentClassField.getOptions());
        }
    }

    private List<ContentClass> getAllContentClasses() throws Exception {
        HibernateContext.getContext().beginTransaction();
        List<ContentClass> list = this.service.getAllContentClassesWithoutMetadata();
        HibernateContext.getContext().commitTransaction();
        return list;
    }

    private List<ContentClassPartner> getAllContentClassPartners() throws Exception {
        HibernateContext.getContext().beginTransaction();
        List<ContentClassPartner> list = this.service.getAllContentClassPartnersWithoutMetadata();
        HibernateContext.getContext().commitTransaction();
        return list;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.out.println("Usage:");
            System.out.println("    ContentClassConverter <oldSpecPath> <oldPropertiesPath> [<outputDir>]");
            System.out.println("where");
            System.out.println("    <oldSpecPath> - path to old spec, e.g. /backup/definition.xml");
            System.out.println("    <oldPropertiesPath> - path to old properties file, e.g. /backup/cablelabs.properties");
            System.out.println("    <outputDir> - optional output folder, e.g. /home/cms/out. Default value is 'out'");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray.length == 2 ? "out" : stringArray[2];
        System.out.println("ContentClassConverter input parameters:");
        System.out.println("    oldSpecPath = " + string);
        System.out.println("    oldPropertiesPath = " + string2);
        System.out.println("    outputDir = " + string3);
        SpecConverter specConverter = new SpecConverter();
        specConverter.setOldSpecPath(string);
        specConverter.setOldSpecPropertiesPath(string2);
        specConverter.setOutputFolder(string3);
        specConverter.process();
        SpecInfo specInfo = specConverter.getSpecInfo();
        NewSpecInfo newSpecInfo = specConverter.getNewSpecInfo();
        ContentClassConverter contentClassConverter = new ContentClassConverter(specInfo, newSpecInfo);
        contentClassConverter.init();
        contentClassConverter.run();
        contentClassConverter.finish();
    }
}

