/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass;

import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassField;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.jaxb.ContentClassJaxbService;
import com.tandbergtv.watchpoint.pmm.title.conf.ContentClassTemplate;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecConverter;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationJaxbService;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.SimpleVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.TitleType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.VariableType;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.List;
import javax.xml.bind.JAXBException;

public class DefaultContentClassConverter {
    private Specification spec;
    private ContentClassMetadata ccMeta;
    private ContentClassAsset currentCCAsset;
    private ContentClassMetadata newCCMeta;
    private ContentClassAsset currentNewCCAsset;

    private static Specification readSpec() throws JAXBException {
        System.out.print("Loading 2.0 spec template from a jar...");
        SpecificationJaxbService specificationJaxbService = new SpecificationJaxbService();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(SpecConverter.class.getClassLoader().getResourceAsStream("definition.xml")));
        Specification specification = specificationJaxbService.unmarshal(bufferedReader);
        System.out.println(" done.");
        return specification;
    }

    private static ContentClassMetadata readCC() throws Exception {
        System.out.print("Loading 2.0 default content class from a jar...");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(ContentClassTemplate.class.getClassLoader().getResourceAsStream("defaultContentClass.xml")));
        ContentClassJaxbService contentClassJaxbService = new ContentClassJaxbService();
        ContentClass contentClass = contentClassJaxbService.unmarshalContentClass(bufferedReader);
        System.out.println(" done.");
        return contentClass.getMetadata();
    }

    private void writeNewCCMeta() throws Exception {
        ContentClassJaxbService contentClassJaxbService = new ContentClassJaxbService();
        String string = contentClassJaxbService.marshalContentClassMetadata(this.newCCMeta, true);
        System.out.println(string);
    }

    public void convert() throws Exception {
        this.spec = DefaultContentClassConverter.readSpec();
        this.ccMeta = DefaultContentClassConverter.readCC();
        this.newCCMeta = new ContentClassMetadata();
        TitleType titleType = this.spec.getTitle();
        this.walkTitleTree(titleType, null);
        this.writeNewCCMeta();
    }

    private void walkTitleTree(TitleType titleType, String string) {
        String string2 = titleType.getName();
        String string3 = string == null ? string2 : string + "/" + string2;
        this.processTitle(titleType, string3);
        if (titleType.getChildTitles() == null) {
            return;
        }
        List<TitleType> list = titleType.getChildTitles().getTitle();
        for (TitleType titleType2 : list) {
            this.walkTitleTree(titleType2, string3);
        }
    }

    private void processTitle(TitleType titleType, String string) {
        this.currentCCAsset = this.ccMeta.getAsset(string);
        if (this.currentCCAsset != null && this.currentCCAsset.isDisabled()) {
            System.out.println("Skipping " + string);
            return;
        }
        System.out.println("Processing " + string);
        this.currentNewCCAsset = new ContentClassAsset(string);
        this.newCCMeta.addAsset(this.currentNewCCAsset);
        List<VariableType> list = titleType.getMetadata().getVariable();
        this.walkVariableTree(list, "/Fields");
    }

    private void walkVariableTree(List<VariableType> list, String string) {
        for (VariableType variableType : list) {
            Object object;
            String string2 = variableType.getName();
            String string3 = string + "/" + string2;
            if (variableType instanceof SimpleVariableType) {
                object = (SimpleVariableType)variableType;
                if (((SimpleVariableType)object).isAttribute()) {
                    string3 = string + "/@" + string2;
                }
                if (!this.processFieldAndSkipChildren(string3)) continue;
                continue;
            }
            if (this.processFieldAndSkipChildren(string3) || (object = variableType.getVariable()) == null || object.isEmpty()) continue;
            this.walkVariableTree((List<VariableType>)object, string3);
        }
    }

    private boolean processFieldAndSkipChildren(String string) {
        ContentClassField contentClassField;
        ContentClassField contentClassField2 = contentClassField = this.currentCCAsset == null ? null : this.currentCCAsset.getField(string);
        if (contentClassField != null) {
            if (contentClassField.isHidden()) {
                return true;
            }
            this.currentNewCCAsset.addField(contentClassField);
            System.out.println("Copied: " + string);
        } else {
            this.currentNewCCAsset.addField(new ContentClassField(string));
            System.out.println("Added new: " + string);
        }
        return false;
    }

    public static void main(String[] stringArray) throws Exception {
        DefaultContentClassConverter defaultContentClassConverter = new DefaultContentClassConverter();
        defaultContentClassConverter.convert();
    }
}

