/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.hibernate;

import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.content.contentclass.entities.ContentClassPartnerList;
import com.tandbergtv.content.contentclass.hibernate.ContentClassEntity;
import com.tandbergtv.content.contentclass.hibernate.ContentClassHibernateFactory;
import com.tandbergtv.content.contentclass.hibernate.ContentClassPartnerEntity;
import com.tandbergtv.content.contentclass.jaxb.ContentClassJaxbService;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.util.ContentClassMerger;
import com.tandbergtv.content.contentclass.util.HibernateContext;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.type.Type;

public class ContentClassServiceHibernate {
    private static Logger logger = Logger.getLogger(ContentClassServiceHibernate.class);

    public List<ContentClass> getAllContentClassesWithoutMetadata() throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String string = "select id, name, description, specialUsageId, isDefault from ContentClassEntity";
            Query query = session.createQuery(string);
            List list = query.list();
            if (list == null || list.isEmpty()) {
                return null;
            }
            return this.createContentClassList(list);
        }
        catch (Exception exception) {
            String string = "Unable to get a list of content classes";
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public List<ContentClass> getPartnerContentClassesWithoutMetadata(long l) throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String string = "select c.id, c.name, c.description, c.specialUsageId, c.isDefault from ContentClassEntity c, ContentClassPartnerEntity p  where c.id = p.contentClassId and p.partnerId = ?";
            Query query = session.createQuery(string);
            query.setLong(0, l);
            List list = query.list();
            if (list == null || list.isEmpty()) {
                return null;
            }
            return this.createContentClassList(list);
        }
        catch (Exception exception) {
            String string = "Unable to get a list of content classes";
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    private List<ContentClass> createContentClassList(List list) {
        if (list == null) {
            return null;
        }
        ArrayList<ContentClass> arrayList = new ArrayList<ContentClass>();
        for (int i = 0; i < list.size(); ++i) {
            Object[] objectArray = (Object[])list.get(i);
            ContentClass contentClass = new ContentClass();
            contentClass.setId((Long)objectArray[0]);
            contentClass.setName((String)objectArray[1]);
            contentClass.setDescription((String)objectArray[2]);
            int n = (Integer)objectArray[3];
            switch (n) {
                case 1: {
                    contentClass.setSpecialUsage(ContentClass.SpecialUsage.PreRoll);
                    break;
                }
                case 2: {
                    contentClass.setSpecialUsage(ContentClass.SpecialUsage.PostRoll);
                    break;
                }
                default: {
                    contentClass.setSpecialUsage(ContentClass.SpecialUsage.None);
                }
            }
            contentClass.setDefault((Boolean)objectArray[4]);
            arrayList.add(contentClass);
        }
        return arrayList;
    }

    public ContentClass getContentClassById(long l, boolean bl) throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassEntity contentClassEntity = (ContentClassEntity)session.get(ContentClassEntity.class, (Serializable)Long.valueOf(l));
            if (contentClassEntity == null) {
                String string = "Content class with id = " + l + " doesn't exist";
                throw new ContentClassPersistenceException(string);
            }
            return ContentClassHibernateFactory.createContentClass(contentClassEntity, bl);
        }
        catch (Exception exception) {
            String string = "Unable to get a content classes with id = " + l;
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public void saveContentClass(ContentClass contentClass) throws ContentClassPersistenceException {
        if (contentClass == null) {
            return;
        }
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassEntity contentClassEntity = ContentClassHibernateFactory.createContentClassHibernate(contentClass);
            session.saveOrUpdate((Object)contentClassEntity);
            contentClass.setId(contentClassEntity.id);
        }
        catch (Exception exception) {
            String string = "Unable to save a content classes with id = " + contentClass.getId();
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public void deleteContentClassById(long l) throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            SQLQuery sQLQuery = session.createSQLQuery("delete from pmm_content_class where id = ?");
            sQLQuery.setLong(0, l);
            sQLQuery.executeUpdate();
        }
        catch (Exception exception) {
            String string = "Unable to delete a content class with id = " + l;
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public ContentClassPartner getContentClassPartner(long l, long l2) throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassPartnerEntity contentClassPartnerEntity = new ContentClassPartnerEntity(l, l2);
            contentClassPartnerEntity = (ContentClassPartnerEntity)session.get(ContentClassPartnerEntity.class, (Serializable)contentClassPartnerEntity);
            if (contentClassPartnerEntity == null) {
                contentClassPartnerEntity = new ContentClassPartnerEntity(l, l2);
            }
            ContentClassPartner contentClassPartner = ContentClassHibernateFactory.createContentClassPartner(contentClassPartnerEntity);
            String string = "select cc.name as className,  p.name as partnerName, p.providerid from pmm_content_class cc, pmm_partner p where cc.id = ? and p.id_ = ?";
            SQLQuery sQLQuery = session.createSQLQuery(string);
            sQLQuery.setLong(0, l);
            sQLQuery.setLong(1, l2);
            Object[] objectArray = (Object[])sQLQuery.uniqueResult();
            if (objectArray == null) {
                throw new ContentClassPersistenceException("Invalid content class " + l + " or partner " + l2);
            }
            contentClassPartner.setContentClassName((String)objectArray[0]);
            contentClassPartner.setPartnerName((String)objectArray[1]);
            contentClassPartner.setProviderId((String)objectArray[2]);
            return contentClassPartner;
        }
        catch (ContentClassPersistenceException contentClassPersistenceException) {
            throw contentClassPersistenceException;
        }
        catch (Exception exception) {
            String string = "Unable to get content class partner with contentClassId = " + l + "and partnerId = " + l2;
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public void saveContentClassPartner(ContentClassPartner contentClassPartner) throws ContentClassPersistenceException {
        if (contentClassPartner == null) {
            return;
        }
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassPartnerEntity contentClassPartnerEntity = ContentClassHibernateFactory.createContentClassPartnerEntity(contentClassPartner);
            session.saveOrUpdate((Object)contentClassPartnerEntity);
        }
        catch (Exception exception) {
            String string = "Unable to save a content class partner with contentClassId = " + contentClassPartner.getContentClassId() + "and partnerId = " + contentClassPartner.getPartnerId();
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public void deleteContentClassPartner(ContentClassPartner contentClassPartner) throws ContentClassPersistenceException {
        if (contentClassPartner == null) {
            return;
        }
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassPartnerEntity contentClassPartnerEntity = new ContentClassPartnerEntity(contentClassPartner.getContentClassId(), contentClassPartner.getPartnerId());
            session.delete((Object)contentClassPartnerEntity);
        }
        catch (Exception exception) {
            String string = "Unable to delete a content class partner with contentClassId = " + contentClassPartner.getContentClassId() + "and partnerId = " + contentClassPartner.getPartnerId();
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    private boolean isSelfPartner(String string) throws Exception {
        String string2 = "select count(*) as cnt from pmm_partner p, pmm_partner_users u where p.id_ = u.partner_id and p.isactive = 1 and p.partnertype = 0 and u.username = ?";
        Session session = HibernateContext.getContext().getCurrentSession();
        SQLQuery sQLQuery = session.createSQLQuery(string2);
        sQLQuery.setString(0, string);
        sQLQuery.addScalar("cnt", (Type)Hibernate.INTEGER);
        int n = (Integer)sQLQuery.uniqueResult();
        return n > 0;
    }

    public List<ContentClassPartner> getAllContentClassPartnersWithoutMetadata() throws ContentClassPersistenceException {
        ArrayList<ContentClassPartner> arrayList = new ArrayList<ContentClassPartner>();
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String string = "select content_class_id as cid, partner_id as pid from pmm_content_class_partner where data is not null";
            SQLQuery sQLQuery = session.createSQLQuery(string);
            sQLQuery.addScalar("cid", (Type)Hibernate.LONG);
            sQLQuery.addScalar("pid", (Type)Hibernate.LONG);
            List list = sQLQuery.list();
            if (list != null && !list.isEmpty()) {
                for (Object e : list) {
                    Object[] objectArray = (Object[])e;
                    Long l = (Long)objectArray[0];
                    Long l2 = (Long)objectArray[1];
                    ContentClassPartner contentClassPartner = new ContentClassPartner(l, l2);
                    arrayList.add(contentClassPartner);
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            String string = "Unable to get content class partners";
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public Map<Long, ContentClassPartnerList> getContentClassPartnerMap(String string) throws ContentClassPersistenceException {
        HashMap<Long, ContentClassPartnerList> hashMap = new HashMap<Long, ContentClassPartnerList>();
        try {
            SQLQuery sQLQuery;
            String string2;
            Session session = HibernateContext.getContext().getCurrentSession();
            if (this.isSelfPartner(string)) {
                string2 = "select p.id_ as pid, p.name as pname, c.id as cid, c.name as cname from pmm_partner p, pmm_content_class c, pmm_content_class_partner cp where p.id_ = cp.partner_id and c.id = cp.content_class_id and p.isactive = 1";
                sQLQuery = session.createSQLQuery(string2);
            } else {
                string2 = "select p.id_ as pid, p.name as pname, c.id as cid, c.name as cname from pmm_partner p, pmm_content_class c, pmm_content_class_partner cp, pmm_partner_users u where p.id_ = cp.partner_id and c.id = cp.content_class_id and p.id_ = u.partner_id and p.isactive = 1 and u.username = ?";
                sQLQuery = session.createSQLQuery(string2);
                sQLQuery.setString(0, string);
            }
            sQLQuery.addScalar("pid", (Type)Hibernate.LONG);
            sQLQuery.addScalar("pname", (Type)Hibernate.STRING);
            sQLQuery.addScalar("cid", (Type)Hibernate.LONG);
            sQLQuery.addScalar("cname", (Type)Hibernate.STRING);
            List list = sQLQuery.list();
            if (list != null && !list.isEmpty()) {
                for (Object e : list) {
                    Object[] objectArray = (Object[])e;
                    Long l = (Long)objectArray[0];
                    String string3 = (String)objectArray[1];
                    Long l2 = (Long)objectArray[2];
                    String string4 = (String)objectArray[3];
                    ContentClassPartnerList contentClassPartnerList = (ContentClassPartnerList)hashMap.get(l);
                    if (contentClassPartnerList == null) {
                        contentClassPartnerList = new ContentClassPartnerList(l);
                        contentClassPartnerList.setPartnerName(string3);
                        hashMap.put(l, contentClassPartnerList);
                    }
                    contentClassPartnerList.addContentClass(l2, string4);
                }
            }
        }
        catch (Exception exception) {
            String string5 = "Unable to get content class partner map";
            logger.error((Object)string5, (Throwable)exception);
            throw new ContentClassPersistenceException(string5, exception);
        }
        return hashMap;
    }

    public Long getContentClassIdByName(String string) throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String string2 = "select id from ContentClassEntity where name = ?";
            Query query = session.createQuery(string2);
            query.setString(0, string);
            return (Long)query.uniqueResult();
        }
        catch (Exception exception) {
            String string3 = "Unable to get content class id by name " + string;
            logger.error((Object)string3, (Throwable)exception);
            throw new ContentClassPersistenceException(string3, exception);
        }
    }

    public Long getDefaultContentClassId() throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String string = "select id from ContentClassEntity where isDefault = 1";
            Query query = session.createQuery(string);
            return (Long)query.uniqueResult();
        }
        catch (Exception exception) {
            String string = "Unable to get default content class";
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public ContentClassPartner getMergedContentClassPartnerMetadata(long l, long l2, boolean bl) throws ContentClassPersistenceException {
        ContentClass contentClass = this.getContentClassById(l, bl);
        if (contentClass == null) {
            return null;
        }
        ContentClassPartner contentClassPartner = this.getContentClassPartner(l, l2);
        if (contentClassPartner == null) {
            return null;
        }
        ContentClassMerger contentClassMerger = new ContentClassMerger();
        ContentClassMetadata contentClassMetadata = contentClassMerger.mergeMetadata(contentClass.getMetadata(), contentClassPartner.getMetadata());
        contentClassPartner.setMetadata(contentClassMetadata);
        return contentClassPartner;
    }

    public void deleteContentClassesById(Collection<Long> collection) throws ContentClassPersistenceException {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        long l = 0L;
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            SQLQuery sQLQuery = session.createSQLQuery("delete from pmm_content_class where id = ?");
            for (Long l2 : collection) {
                l = l2;
                sQLQuery.setLong(0, l2.longValue());
                sQLQuery.executeUpdate();
            }
        }
        catch (Exception exception) {
            String string = "Unable to delete a content class with id = " + l;
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public boolean contentClassNameExists(String string) throws ContentClassPersistenceException {
        String string2 = "select count(*) as cnt from pmm_content_class where name = ?";
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            SQLQuery sQLQuery = session.createSQLQuery(string2);
            sQLQuery.setString(0, string);
            sQLQuery.addScalar("cnt", (Type)Hibernate.INTEGER);
            Integer n = (Integer)sQLQuery.uniqueResult();
            return n > 0;
        }
        catch (Exception exception) {
            logger.error((Object)"Unable to check if content class name exists", (Throwable)exception);
            throw new ContentClassPersistenceException(exception);
        }
    }

    public boolean contentClassAssociatedWithTitle(long l) throws ContentClassPersistenceException {
        String string = "select count(*) as cnt from pmm_title where content_class_id = ?";
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            SQLQuery sQLQuery = session.createSQLQuery(string);
            sQLQuery.setLong(0, l);
            sQLQuery.addScalar("cnt", (Type)Hibernate.INTEGER);
            Integer n = (Integer)sQLQuery.uniqueResult();
            return n > 0;
        }
        catch (Exception exception) {
            logger.error((Object)"Unable to check if a content class is associated with titles", (Throwable)exception);
            throw new ContentClassPersistenceException(exception);
        }
    }

    public boolean contentClassPartnerExists(long l, long l2) throws ContentClassPersistenceException {
        String string = "select count(*) as cnt from pmm_content_class_partner where content_class_id = ? and partner_id = ?";
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            SQLQuery sQLQuery = session.createSQLQuery(string);
            sQLQuery.setLong(0, l);
            sQLQuery.setLong(1, l2);
            sQLQuery.addScalar("cnt", (Type)Hibernate.INTEGER);
            Integer n = (Integer)sQLQuery.uniqueResult();
            return n > 0;
        }
        catch (Exception exception) {
            logger.error((Object)"Unable to check if a content class partner exists", (Throwable)exception);
            throw new ContentClassPersistenceException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ContentClassPartner> getContentClassPartnersByContentClassId(long l, boolean bl) throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String string = bl ? "select cc.name as cname, p.id_ as pid, p.name as pname, p.providerid, ccp.data from pmm_content_class_partner ccp, pmm_partner p, pmm_content_class cc where ccp.content_class_id = cc.id and ccp.partner_id = p.id_ and ccp.content_class_id = ?" : "select cc.name as cname, p.id_ as pid, p.name as pname, p.providerid from pmm_content_class_partner ccp, pmm_partner p, pmm_content_class cc where ccp.content_class_id = cc.id and ccp.partner_id = p.id_ and ccp.content_class_id = ?";
            SQLQuery sQLQuery = session.createSQLQuery(string);
            sQLQuery.setLong(0, l);
            List list = sQLQuery.list();
            if (list == null || list.isEmpty()) {
                return null;
            }
            ContentClassJaxbService contentClassJaxbService = new ContentClassJaxbService();
            ArrayList<ContentClassPartner> arrayList = new ArrayList<ContentClassPartner>();
            for (Object e : list) {
                Clob clob;
                Object[] objectArray = (Object[])e;
                ContentClassPartner contentClassPartner = new ContentClassPartner();
                contentClassPartner.setContentClassId(l);
                contentClassPartner.setContentClassName((String)objectArray[0]);
                BigDecimal bigDecimal = (BigDecimal)objectArray[1];
                if (bigDecimal != null) {
                    contentClassPartner.setPartnerId(bigDecimal.longValue());
                }
                contentClassPartner.setPartnerName((String)objectArray[2]);
                contentClassPartner.setProviderId((String)objectArray[3]);
                if (bl && (clob = (Clob)objectArray[4]) != null) {
                    Reader reader = clob.getCharacterStream();
                    try {
                        ContentClassMetadata contentClassMetadata = contentClassJaxbService.unmarshalContentClassMetadata(reader);
                        contentClassPartner.setMetadata(contentClassMetadata);
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                arrayList.add(contentClassPartner);
            }
            return arrayList;
        }
        catch (Exception exception) {
            String string = "Unable to get content class partners with contentClassId = " + l;
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public String marshalContentClass(ContentClass contentClass) throws ContentClassPersistenceException {
        ContentClassJaxbService contentClassJaxbService = new ContentClassJaxbService();
        return contentClassJaxbService.marshalContentClass(contentClass, false);
    }

    public ContentClass unmarshalContentClass(String string) throws ContentClassPersistenceException {
        ContentClassJaxbService contentClassJaxbService = new ContentClassJaxbService();
        return contentClassJaxbService.unmarshalContentClass(string);
    }

    public String marshalContentClassWithPartners(ContentClass contentClass, List<ContentClassPartner> list) throws ContentClassPersistenceException {
        ContentClassJaxbService contentClassJaxbService = new ContentClassJaxbService();
        return contentClassJaxbService.marshalContentClassWithPartners(contentClass, list, false);
    }

    public ContentClass unmarshalContentClassWithPartners(String string, List<ContentClassPartner> list) throws ContentClassPersistenceException {
        ContentClassJaxbService contentClassJaxbService = new ContentClassJaxbService();
        return contentClassJaxbService.unmarshalContentClassWithPartners(string, list);
    }

    public Long getPartnerIdByName(String string) throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String string2 = "select id_ as id from pmm_partner where name = ?";
            SQLQuery sQLQuery = session.createSQLQuery(string2);
            sQLQuery.addScalar("id", (Type)Hibernate.LONG);
            sQLQuery.setString(0, string);
            return (Long)sQLQuery.uniqueResult();
        }
        catch (Exception exception) {
            String string3 = "Unable to get partner id by name " + string;
            logger.error((Object)string3, (Throwable)exception);
            throw new ContentClassPersistenceException(string3, exception);
        }
    }
}

