/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.jaxb;

import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.content.contentclass.jaxb.ContentClassJaxbFactory;
import com.tandbergtv.content.contentclass.jaxb.model.ContentClassPartnerType;
import com.tandbergtv.content.contentclass.jaxb.model.ContentClassType;
import com.tandbergtv.content.contentclass.jaxb.model.MetadataType;
import com.tandbergtv.content.contentclass.jaxb.model.ObjectFactory;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;

public class ContentClassJaxbService {
    private final String JAXB_CONTEXT_PATH = "com.tandbergtv.content.contentclass.jaxb.model";
    private static Logger logger = Logger.getLogger(ContentClassJaxbService.class);

    public String marshalContentClass(ContentClass contentClass, boolean bl) throws ContentClassPersistenceException {
        if (contentClass == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        this.marshalContentClass(contentClass, stringWriter, bl);
        return stringWriter.toString();
    }

    public void marshalContentClass(ContentClass contentClass, Writer writer) throws ContentClassPersistenceException {
        this.marshalContentClass(contentClass, writer, false);
    }

    public void marshalContentClass(ContentClass contentClass, Writer writer, boolean bl) throws ContentClassPersistenceException {
        try {
            ContentClassJaxbFactory contentClassJaxbFactory = new ContentClassJaxbFactory();
            ContentClassType contentClassType = contentClassJaxbFactory.createContentClassType(contentClass);
            ObjectFactory objectFactory = new ObjectFactory();
            JAXBElement<ContentClassType> jAXBElement = objectFactory.createContentClass(contentClassType);
            Marshaller marshaller = this.createMarshaller(bl);
            marshaller.marshal(jAXBElement, writer);
        }
        catch (Exception exception) {
            String string = "Unable to marshal content class";
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public void marshalContentClassWithPartners(ContentClass contentClass, List<ContentClassPartner> list, Writer writer, boolean bl) throws ContentClassPersistenceException {
        try {
            ContentClassJaxbFactory contentClassJaxbFactory = new ContentClassJaxbFactory();
            ContentClassType contentClassType = contentClassJaxbFactory.createContentClassTypeWithPartners(contentClass, list);
            ObjectFactory objectFactory = new ObjectFactory();
            JAXBElement<ContentClassType> jAXBElement = objectFactory.createContentClass(contentClassType);
            Marshaller marshaller = this.createMarshaller(bl);
            marshaller.marshal(jAXBElement, writer);
        }
        catch (Exception exception) {
            String string = "Unable to marshal content class";
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public String marshalContentClassWithPartners(ContentClass contentClass, List<ContentClassPartner> list, boolean bl) throws ContentClassPersistenceException {
        if (contentClass == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        this.marshalContentClassWithPartners(contentClass, list, stringWriter, bl);
        return stringWriter.toString();
    }

    public ContentClass unmarshalContentClassWithPartners(Reader reader, List<ContentClassPartner> list) throws ContentClassPersistenceException {
        try {
            Unmarshaller unmarshaller = this.createUnmarshaller();
            JAXBElement jAXBElement = (JAXBElement)unmarshaller.unmarshal(reader);
            ContentClassType contentClassType = (ContentClassType)jAXBElement.getValue();
            ContentClassJaxbFactory contentClassJaxbFactory = new ContentClassJaxbFactory();
            ContentClass contentClass = contentClassJaxbFactory.createContentClass(contentClassType);
            if (contentClass == null) {
                return null;
            }
            List<ContentClassPartnerType> list2 = null;
            if (contentClassType.getPartners() != null) {
                list2 = contentClassType.getPartners().getPartner();
            }
            if (list != null && list2 != null) {
                list.clear();
                for (ContentClassPartnerType contentClassPartnerType : list2) {
                    ContentClassPartner contentClassPartner = contentClassJaxbFactory.createContentClassPartner(contentClassPartnerType);
                    contentClassPartner.setContentClassName(contentClass.getName());
                    list.add(contentClassPartner);
                }
            }
            return contentClass;
        }
        catch (Exception exception) {
            String string = "Unable to unmarshal content class";
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public ContentClass unmarshalContentClassWithPartners(String string, List<ContentClassPartner> list) throws ContentClassPersistenceException {
        if (string == null) {
            return null;
        }
        StringReader stringReader = new StringReader(string);
        return this.unmarshalContentClassWithPartners(stringReader, list);
    }

    public void marshalContentClassMetadata(ContentClassMetadata contentClassMetadata, Writer writer) throws ContentClassPersistenceException {
        this.marshalContentClassMetadata(contentClassMetadata, writer, false);
    }

    public void marshalContentClassMetadata(ContentClassMetadata contentClassMetadata, Writer writer, boolean bl) throws ContentClassPersistenceException {
        try {
            ContentClassJaxbFactory contentClassJaxbFactory = new ContentClassJaxbFactory();
            MetadataType metadataType = contentClassJaxbFactory.createMetadataType(contentClassMetadata);
            ObjectFactory objectFactory = new ObjectFactory();
            JAXBElement<MetadataType> jAXBElement = objectFactory.createMetadata(metadataType);
            Marshaller marshaller = this.createMarshaller(bl);
            marshaller.marshal(jAXBElement, writer);
        }
        catch (Exception exception) {
            String string = "Unable to marshal content class";
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public String marshalContentClassMetadata(ContentClassMetadata contentClassMetadata, boolean bl) throws ContentClassPersistenceException {
        if (contentClassMetadata == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        this.marshalContentClassMetadata(contentClassMetadata, stringWriter, bl);
        return stringWriter.toString();
    }

    public String marshalContentClassMetadata(ContentClassMetadata contentClassMetadata) throws ContentClassPersistenceException {
        return this.marshalContentClassMetadata(contentClassMetadata, false);
    }

    public ContentClass unmarshalContentClass(Reader reader) throws ContentClassPersistenceException {
        try {
            Unmarshaller unmarshaller = this.createUnmarshaller();
            JAXBElement jAXBElement = (JAXBElement)unmarshaller.unmarshal(reader);
            ContentClassType contentClassType = (ContentClassType)jAXBElement.getValue();
            ContentClassJaxbFactory contentClassJaxbFactory = new ContentClassJaxbFactory();
            return contentClassJaxbFactory.createContentClass(contentClassType);
        }
        catch (Exception exception) {
            String string = "Unable to unmarshal content class";
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public ContentClass unmarshalContentClass(String string) throws ContentClassPersistenceException {
        if (string == null) {
            return null;
        }
        StringReader stringReader = new StringReader(string);
        return this.unmarshalContentClass(stringReader);
    }

    public ContentClassMetadata unmarshalContentClassMetadata(Reader reader) throws ContentClassPersistenceException {
        try {
            Unmarshaller unmarshaller = this.createUnmarshaller();
            JAXBElement jAXBElement = (JAXBElement)unmarshaller.unmarshal(reader);
            MetadataType metadataType = (MetadataType)jAXBElement.getValue();
            ContentClassJaxbFactory contentClassJaxbFactory = new ContentClassJaxbFactory();
            return contentClassJaxbFactory.createContentClassMetadata(metadataType);
        }
        catch (Exception exception) {
            String string = "Unable to unmarshal content class";
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public ContentClassMetadata unmarshalContentClassMetadata(String string) throws ContentClassPersistenceException {
        if (string == null) {
            return null;
        }
        StringReader stringReader = new StringReader(string);
        return this.unmarshalContentClassMetadata(stringReader);
    }

    private Marshaller createMarshaller(boolean bl) throws JAXBException {
        JAXBContext jAXBContext = JAXBContext.newInstance((String)"com.tandbergtv.content.contentclass.jaxb.model");
        Marshaller marshaller = jAXBContext.createMarshaller();
        if (bl) {
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        }
        return marshaller;
    }

    private Unmarshaller createUnmarshaller() throws JAXBException {
        JAXBContext jAXBContext = JAXBContext.newInstance((String)"com.tandbergtv.content.contentclass.jaxb.model");
        return jAXBContext.createUnmarshaller();
    }
}

