/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.lookupkey;

import com.tandbergtv.content.contentclass.util.HibernateContext;
import com.tandbergtv.content.lookupkey.ConfigFileEntry;
import com.tandbergtv.content.lookupkey.LookupKeyService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LookupKeyConverter {
    private static final String FILE_NAME = "/opt/tandbergtv/cms/conf/contentMgmt/lookupKeys.txt";
    private static final String FILE_NAME2 = "/opt/tandbergtv/cms/conf/contentMgmt/lookupKeys.txt.rpmsave";
    private List<ConfigFileEntry> entries = new ArrayList<ConfigFileEntry>();
    private Map<String, Long> lookupKeys = new HashMap<String, Long>();
    LookupKeyService service = new LookupKeyService();

    public void init() throws Exception {
        HibernateContext.getContext().initializeContext();
    }

    public void run() throws Exception {
        this.readFile();
        this.insertKeys();
        this.insertAssetTypes();
    }

    private void readFile() throws Exception {
        String string;
        File file = new File(FILE_NAME);
        if (!file.exists()) {
            System.out.println("/opt/tandbergtv/cms/conf/contentMgmt/lookupKeys.txt doesn't exist.");
            file = new File(FILE_NAME2);
            if (!file.exists()) {
                System.out.println("/opt/tandbergtv/cms/conf/contentMgmt/lookupKeys.txt.rpmsave doesn't exist.");
                System.exit(1);
            }
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray;
            if ((string = string.trim()).startsWith("#") || !string.contains("-") || (stringArray = string.split("-")).length < 2) continue;
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            if (string2 != null && string3 != null) {
                string2 = string2.trim();
                string3 = string3.trim();
                if (string2.length() > 0 && string3.length() > 0) {
                    ConfigFileEntry configFileEntry = new ConfigFileEntry();
                    configFileEntry.assetType = string2;
                    configFileEntry.lookupKey = string3;
                    this.entries.add(configFileEntry);
                    this.lookupKeys.put(configFileEntry.lookupKey, 0L);
                    continue;
                }
                System.out.println("assetType = " + string2 + ", lookupKey = " + string3);
                System.out.println("Either assetType or lookupKey is empty. Skipping this line...");
                continue;
            }
            System.out.println("assetType = " + string2 + ", lookupKey = " + string3);
            System.out.println("Either assetType or lookupKey is null. Skipping this line...");
        }
    }

    private void insertKeys() {
        HibernateContext.getContext().beginTransaction();
        for (Map.Entry<String, Long> entry : this.lookupKeys.entrySet()) {
            String string = entry.getKey();
            Long l = this.service.findLookupKeyIdByName(string);
            if (l == null) {
                System.out.println("Inserting lookup key " + string);
                l = this.service.insertLookupKey(string);
            }
            entry.setValue(l);
        }
        HibernateContext.getContext().commitTransaction();
    }

    private void insertAssetTypes() {
        for (ConfigFileEntry configFileEntry : this.entries) {
            System.out.println("Processing lookupKey = " + configFileEntry.lookupKey + ", assetType = " + configFileEntry.assetType);
            Long l = this.lookupKeys.get(configFileEntry.lookupKey);
            if (l == null) {
                System.out.println("Could not find id for lookup key " + configFileEntry.lookupKey);
                continue;
            }
            HibernateContext.getContext().beginTransaction();
            this.service.saveLookupKeyAsset(l, configFileEntry.assetType);
            HibernateContext.getContext().commitTransaction();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        LookupKeyConverter lookupKeyConverter = new LookupKeyConverter();
        lookupKeyConverter.init();
        lookupKeyConverter.run();
    }
}

