/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassField;
import com.tandbergtv.content.contentclass.jaxb.ContentClassJaxbService;
import com.tandbergtv.util.StringUtil;
import com.tandbergtv.watchpoint.pmm.title.conf.FieldInfo;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecInfo;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleInfo;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.SimpleVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.TitleType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.VariableType;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.List;

public class ContentClassTemplate {
    private boolean DEBUG = false;
    private SpecInfo specInfo;
    private TitleInfo currentTitleInfo;
    private ContentClassAsset currentContentClassAsset;
    private ContentClass defaultContentClass;

    public ContentClassTemplate(SpecInfo specInfo) {
        this.specInfo = specInfo;
    }

    public ContentClass createDefaultContentClass() throws Exception {
        this.defaultContentClass = this.loadDefaultContentClassTemplate();
        TitleType titleType = this.specInfo.newSpec.getTitle();
        this.walkTitleTree(titleType, null);
        this.debug("======================================================");
        return this.defaultContentClass;
    }

    private void walkTitleTree(TitleType titleType, String string) {
        String string2 = titleType.getName();
        String string3 = string == null ? string2 : string + "/" + string2;
        this.processTitle(titleType, string3);
        if (titleType.getChildTitles() == null) {
            return;
        }
        List<TitleType> list = titleType.getChildTitles().getTitle();
        for (TitleType titleType2 : list) {
            this.walkTitleTree(titleType2, string3);
        }
    }

    private void processTitle(TitleType titleType, String string) {
        this.debug("======================================================");
        this.debug(string);
        this.debug("======================================================");
        this.currentTitleInfo = this.specInfo.findTitleByPath(string);
        this.currentContentClassAsset = this.defaultContentClass.getMetadata().getAsset(string);
        if (this.currentContentClassAsset == null) {
            System.out.println("WARNING: Default content class doesn't contain asset " + string + ". Skipping.");
            return;
        }
        if (this.currentTitleInfo == null) {
            this.currentContentClassAsset.setDisabled(true);
            this.debug("Disabled asset " + string);
        } else {
            if (!this.specInfo.convertingFrom2x()) {
                if (this.currentTitleInfo.min != null) {
                    this.currentContentClassAsset.setMin(this.currentTitleInfo.min < 0 ? 99999 : this.currentTitleInfo.min);
                }
                if (this.currentTitleInfo.max != null) {
                    this.currentContentClassAsset.setMax(this.currentTitleInfo.max < 0 ? 99999 : this.currentTitleInfo.max);
                }
                if (this.currentTitleInfo.batchMin != null) {
                    this.currentContentClassAsset.setBatchMin(this.currentTitleInfo.batchMin < 0 ? 99999 : this.currentTitleInfo.batchMin);
                }
                if (this.currentTitleInfo.batchMax != null) {
                    this.currentContentClassAsset.setBatchMax(this.currentTitleInfo.batchMax < 0 ? 99999 : this.currentTitleInfo.batchMax);
                }
                this.currentContentClassAsset.setRequiresFile(this.currentTitleInfo.hasAsset);
                this.currentContentClassAsset.setHideFileView(this.currentTitleInfo.hideFileView);
            }
            List<VariableType> list = titleType.getMetadata().getVariable();
            this.walkVariableTree(list, "/Fields");
        }
    }

    private void walkVariableTree(List<VariableType> list, String string) {
        for (VariableType variableType : list) {
            List<VariableType> list2;
            Object object;
            String string2 = variableType.getName();
            String string3 = string + "/" + string2;
            if (variableType instanceof SimpleVariableType && ((SimpleVariableType)(object = (SimpleVariableType)variableType)).isAttribute()) {
                string3 = string + "/@" + string2;
            }
            object = this.currentContentClassAsset.getField(string3);
            FieldInfo fieldInfo = this.currentTitleInfo.getFieldInfo(string3);
            if (fieldInfo == null && !variableType.isShowCollapsed()) {
                if (object == null) {
                    object = new ContentClassField(string3);
                    if (variableType instanceof SimpleVariableType) {
                        ((ContentClassField)object).setAttribute(((SimpleVariableType)variableType).isAttribute());
                    }
                    this.currentContentClassAsset.addField((ContentClassField)object);
                }
                ((ContentClassField)object).setHidden(true);
                this.debug("Disabled variable " + string3);
                continue;
            }
            if (object == null && fieldInfo != null && (fieldInfo.autoFillable || fieldInfo.min != null || fieldInfo.max != null || fieldInfo.batch)) {
                object = new ContentClassField(string3);
                if (variableType instanceof SimpleVariableType) {
                    ((ContentClassField)object).setAttribute(((SimpleVariableType)variableType).isAttribute());
                }
                this.currentContentClassAsset.addField((ContentClassField)object);
            }
            if (object != null && fieldInfo != null && !this.specInfo.convertingFrom2x()) {
                ((ContentClassField)object).setHidden(false);
                ((ContentClassField)object).setAutofillable(fieldInfo.autoFillable);
                if (!StringUtil.isEmpty(fieldInfo.autoFillProvider)) {
                    ((ContentClassField)object).setAutofillProvider(fieldInfo.autoFillProvider);
                }
                if (fieldInfo.min != null) {
                    ((ContentClassField)object).setMin(fieldInfo.min > 0 ? fieldInfo.min : null);
                }
                if (fieldInfo.max != null) {
                    ((ContentClassField)object).setMax(fieldInfo.max > 0 ? fieldInfo.max : null);
                }
                ((ContentClassField)object).setIncludeInBatch(string3.startsWith("/Fields/CustomFields/CustomField[") ? false : fieldInfo.batch);
            }
            if ((list2 = variableType.getVariable()) == null || list2.isEmpty()) continue;
            this.walkVariableTree(list2, string3);
        }
    }

    private ContentClass loadDefaultContentClassTemplate() throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(ContentClassTemplate.class.getClassLoader().getResourceAsStream("defaultContentClass.xml")));
        ContentClassJaxbService contentClassJaxbService = new ContentClassJaxbService();
        return contentClassJaxbService.unmarshalContentClass(bufferedReader);
    }

    private void debug(String string) {
        if (this.DEBUG) {
            System.out.println(string);
        }
    }
}

