/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.util.StringUtil;
import com.tandbergtv.watchpoint.pmm.title.conf.DomUtil;
import com.tandbergtv.watchpoint.pmm.title.conf.FieldInfo;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecInfo;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OldSpecParser {
    private String oldSpecPath;
    private SpecInfo specInfo;
    private TitleInfo currentTitleInfo;

    public OldSpecParser(String string, SpecInfo specInfo) {
        this.oldSpecPath = string;
        this.specInfo = specInfo;
    }

    public void parse() throws Exception {
        Document document = DomUtil.readDocument(this.oldSpecPath);
        Element element = DomUtil.getFirstChildElement(document);
        if (!"specification".equalsIgnoreCase(element.getNodeName())) {
            throw new Exception("Expected <specification>, got <" + element.getNodeName() + ">");
        }
        this.specInfo.oldSpecName = element.getAttribute("name");
        this.processChildTitles(element, null);
    }

    private void processChildTitles(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase("title")) continue;
            this.processTitle((Element)node, string);
        }
    }

    private void processTitle(Element element, String string) {
        Element element2;
        String string2 = DomUtil.getFirstChildElementValue("name", element);
        String string3 = string == null ? string2 : string + "/" + string2;
        this.currentTitleInfo = this.specInfo.findTitleByPath(string3);
        this.currentTitleInfo.min = StringUtil.parseInteger(DomUtil.getFirstChildElementValue("min", element));
        this.currentTitleInfo.max = StringUtil.parseInteger(DomUtil.getFirstChildElementValue("max", element));
        this.currentTitleInfo.batchMin = StringUtil.parseInteger(DomUtil.getFirstChildElementValue("batchMin", element));
        this.currentTitleInfo.batchMax = StringUtil.parseInteger(DomUtil.getFirstChildElementValue("batchMax", element));
        this.currentTitleInfo.hasAsset = this.parseBoolean(DomUtil.getFirstChildElementValue("hasAsset", element));
        this.currentTitleInfo.hideFileView = this.parseBoolean(DomUtil.getFirstChildElementValue("hideFileView", element));
        Element element3 = DomUtil.getFirstChildElement("metadata", element);
        if (element3 != null) {
            this.processVariables(element3, "/Fields");
        }
        if ((element2 = DomUtil.getFirstChildElement("childTitles", element)) != null) {
            this.processChildTitles(element2, string3);
        }
    }

    private void processVariables(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase("variable")) continue;
            Element element2 = (Element)node;
            String string2 = element2.getAttribute("name");
            boolean bl = this.parseBoolean(element2.getAttribute("attribute"));
            String string3 = element2.getAttribute("autoFillProvider");
            boolean bl2 = this.parseBoolean(element2.getAttribute("autoFillable"));
            String string4 = bl ? string + "/@" + string2 : string + "/" + string2;
            FieldInfo fieldInfo = this.currentTitleInfo.getFieldInfo(string4);
            if (fieldInfo == null) {
                System.out.println("WARNING: Could not get FieldInfo for " + string4);
            } else {
                fieldInfo.isAttribute = bl;
                fieldInfo.min = StringUtil.parseInteger(element2.getAttribute("min"));
                fieldInfo.max = StringUtil.parseInteger(element2.getAttribute("max"));
                fieldInfo.autoFillable = bl2;
                fieldInfo.autoFillProvider = string3;
                fieldInfo.job = this.parseBoolean(element2.getAttribute("jobParameter"));
                fieldInfo.batch = this.parseBoolean(element2.getAttribute("batch"));
            }
            if (!StringUtil.isEmpty(string3)) {
                this.specInfo.addAutoFillProvider(string3);
            }
            this.processVariables(element2, string4);
        }
    }

    private boolean parseBoolean(String string) {
        return string != null && string.equalsIgnoreCase("true");
    }

    private boolean parseBoolean(String string, boolean bl) {
        if (StringUtil.isEmpty(string)) {
            return bl;
        }
        return string.equalsIgnoreCase("true");
    }
}

