/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.watchpoint.pmm.title.conf.FieldInfo;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecInfo;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationParserUtil;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleInfo;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.BooleanVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.FloatVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.IntegerVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.SimpleVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.StringVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.TitleType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.VariableType;
import java.util.List;

public class OldSpecificationHandler {
    private SpecInfo info;
    private TitleInfo currentTitleInfo;

    public OldSpecificationHandler(SpecInfo specInfo) {
        this.info = specInfo;
    }

    public void process() {
        TitleType titleType = this.info.oldSpec.getTitle();
        this.walkTitleTree(titleType, null);
    }

    private void walkTitleTree(TitleType titleType, String string) {
        String string2 = titleType.getName();
        String string3 = string == null ? string2 : string + "/" + string2;
        this.processTitle(titleType, string3);
        if (titleType.getChildTitles() == null) {
            return;
        }
        List<TitleType> list = titleType.getChildTitles().getTitle();
        for (TitleType titleType2 : list) {
            this.walkTitleTree(titleType2, string3);
        }
    }

    private void processTitle(TitleType titleType, String string) {
        this.currentTitleInfo = this.info.addTitle(string);
        this.currentTitleInfo.setCustomFieldsRef(SpecificationParserUtil.findCustomFieldsVariable(titleType));
        List<VariableType> list = titleType.getMetadata().getVariable();
        this.walkVariableTree(list, "/Fields");
    }

    private void walkVariableTree(List<VariableType> list, String string) {
        for (VariableType variableType : list) {
            Object object;
            String string2 = variableType.getName();
            String string3 = string + "/" + string2;
            if (variableType instanceof SimpleVariableType) {
                object = (SimpleVariableType)variableType;
                if (((SimpleVariableType)object).isAttribute()) {
                    string3 = string + "/@" + string2;
                }
                this.currentTitleInfo.addVariablePath(string3);
                this.processOptions(string3, (SimpleVariableType)object);
            } else {
                this.currentTitleInfo.addVariablePath(string3);
            }
            if ((object = variableType.getVariable()) == null || object.isEmpty()) continue;
            this.walkVariableTree((List<VariableType>)object, string3);
        }
    }

    private void processOptions(String string, SimpleVariableType simpleVariableType) {
        block6: {
            List<FloatVariableType.Options.Option> list;
            FloatVariableType floatVariableType;
            block8: {
                List<IntegerVariableType.Options.Option> list2;
                block7: {
                    List<BooleanVariableType.Options.Option> list3;
                    block5: {
                        List<StringVariableType.Options.Option> list4;
                        if (!(simpleVariableType instanceof StringVariableType)) break block5;
                        StringVariableType stringVariableType = (StringVariableType)simpleVariableType;
                        if (stringVariableType.getOptions() == null || (list4 = stringVariableType.getOptions().getOption()) == null) break block6;
                        FieldInfo fieldInfo = this.currentTitleInfo.getFieldInfo(string);
                        fieldInfo.dataType = FieldInfo.DataType.STRING;
                        fieldInfo.setAnyOptionValueAllowed(stringVariableType.getOptions().isAnyValueAllowed());
                        for (StringVariableType.Options.Option option : list4) {
                            fieldInfo.addOption(option.getName(), option.getValue());
                        }
                        break block6;
                    }
                    if (!(simpleVariableType instanceof BooleanVariableType)) break block7;
                    BooleanVariableType booleanVariableType = (BooleanVariableType)simpleVariableType;
                    if (booleanVariableType.getOptions() == null || (list3 = booleanVariableType.getOptions().getOption()) == null) break block6;
                    FieldInfo fieldInfo = this.currentTitleInfo.getFieldInfo(string);
                    fieldInfo.dataType = FieldInfo.DataType.BOOLEAN;
                    fieldInfo.setAnyOptionValueAllowed(booleanVariableType.getOptions().isAnyValueAllowed());
                    for (BooleanVariableType.Options.Option option : list3) {
                        fieldInfo.addOption(option.getName(), option.isValue() ? "true" : "false");
                    }
                    break block6;
                }
                if (!(simpleVariableType instanceof IntegerVariableType)) break block8;
                IntegerVariableType integerVariableType = (IntegerVariableType)simpleVariableType;
                if (integerVariableType.getOptions() == null || (list2 = integerVariableType.getOptions().getOption()) == null) break block6;
                FieldInfo fieldInfo = this.currentTitleInfo.getFieldInfo(string);
                fieldInfo.dataType = FieldInfo.DataType.INTEGER;
                fieldInfo.setAnyOptionValueAllowed(integerVariableType.getOptions().isAnyValueAllowed());
                for (IntegerVariableType.Options.Option option : list2) {
                    fieldInfo.addOption(option.getName(), String.valueOf(option.getValue()));
                }
                break block6;
            }
            if (simpleVariableType instanceof FloatVariableType && (floatVariableType = (FloatVariableType)simpleVariableType).getOptions() != null && (list = floatVariableType.getOptions().getOption()) != null) {
                FieldInfo fieldInfo = this.currentTitleInfo.getFieldInfo(string);
                fieldInfo.dataType = FieldInfo.DataType.FLOAT;
                fieldInfo.setAnyOptionValueAllowed(floatVariableType.getOptions().isAnyValueAllowed());
                for (FloatVariableType.Options.Option option : list) {
                    fieldInfo.addOption(option.getName(), String.valueOf(option.getValue()));
                }
            }
        }
    }
}

