/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.content.contentclass.util.XPathTranslator;
import com.tandbergtv.watchpoint.pmm.title.conf.AttributeHandler;
import com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldDataTypeMappingHandler;
import com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldHandler;
import com.tandbergtv.watchpoint.pmm.title.conf.NewSpecInfo;
import com.tandbergtv.watchpoint.pmm.title.conf.OldSpecParser;
import com.tandbergtv.watchpoint.pmm.title.conf.OldSpecificationHandler;
import com.tandbergtv.watchpoint.pmm.title.conf.OptionHandler;
import com.tandbergtv.watchpoint.pmm.title.conf.PropertyConverter;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecInfo;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationJaxbService;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.AutofillProviderType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.Specification;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class SpecConverter {
    private SpecInfo specInfo;
    private NewSpecInfo newSpecInfo = new NewSpecInfo();
    private String oldSpecPath;
    private String oldSpecPropertiesPath;
    private String outputFolder;
    private String newSpecOutPath;
    private String cfDataTypeMappingOutPath;
    private static final String FILE_NAME_NEW_SPEC = "definition.xml";
    private static final String FILE_NAME_DATATYPE_MAPPING = "cfDataTypeMapping.dat";

    public SpecInfo getSpecInfo() {
        return this.specInfo;
    }

    public NewSpecInfo getNewSpecInfo() {
        return this.newSpecInfo;
    }

    public void setOutputFolder(String string) {
        this.outputFolder = string;
    }

    public void setOldSpecPath(String string) {
        this.oldSpecPath = string;
    }

    public void setOldSpecPropertiesPath(String string) {
        this.oldSpecPropertiesPath = string;
    }

    private void init() throws Exception {
        System.out.print("Loading XPath translator mapping...");
        XPathTranslator xPathTranslator = XPathTranslator.instance();
        xPathTranslator.init();
        System.out.println(" done");
    }

    public void process() throws Exception {
        Object object;
        this.init();
        if (this.outputFolder == null) {
            this.newSpecOutPath = FILE_NAME_NEW_SPEC;
            this.cfDataTypeMappingOutPath = FILE_NAME_DATATYPE_MAPPING;
        } else {
            object = new File(this.outputFolder);
            if (!((File)object).exists()) {
                ((File)object).mkdirs();
            }
            this.newSpecOutPath = new File((File)object, FILE_NAME_NEW_SPEC).getAbsolutePath();
            this.cfDataTypeMappingOutPath = new File((File)object, FILE_NAME_DATATYPE_MAPPING).getAbsolutePath();
        }
        this.specInfo = this.loadSpecs(this.oldSpecPath);
        this.processOldSpec();
        this.mergeCustomFields();
        this.mergeOptions();
        this.mergeAutoFillProviders();
        this.writeSpec(this.specInfo.newSpec, this.newSpecOutPath);
        this.createCustomFieldDataTypeMapping(this.specInfo.newSpec);
        object = new PropertyConverter();
        ((PropertyConverter)object).process(this.specInfo, this.oldSpecPropertiesPath, this.outputFolder);
        this.processAttributes(this.specInfo, this.newSpecInfo);
    }

    private void mergeAutoFillProviders() {
        System.out.print("Merging autofill providers...");
        if (this.specInfo.convertingFrom2x()) {
            this.mergeAutoFillProvidersFrom2x();
        } else {
            this.mergeAutoFillProvidersFrom1x();
        }
        System.out.println(" done.");
    }

    private void mergeAutoFillProvidersFrom2x() {
        if (this.specInfo.oldSpec.getAutofillProviders() == null) {
            return;
        }
        List<AutofillProviderType> list = this.specInfo.oldSpec.getAutofillProviders().getProvider();
        if (list == null || list.isEmpty()) {
            return;
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        List<AutofillProviderType> list2 = this.specInfo.newSpec.getAutofillProviders().getProvider();
        for (AutofillProviderType object : list2) {
            treeMap.put(object.getName(), object.getJavaClass());
        }
        for (AutofillProviderType autofillProviderType : list) {
            treeMap.put(autofillProviderType.getName(), autofillProviderType.getJavaClass());
        }
        list2.clear();
        for (Map.Entry entry : treeMap.entrySet()) {
            AutofillProviderType autofillProviderType = new AutofillProviderType();
            autofillProviderType.setName((String)entry.getKey());
            autofillProviderType.setJavaClass((String)entry.getValue());
            list2.add(autofillProviderType);
        }
    }

    private void mergeAutoFillProvidersFrom1x() {
        Set<String> set = this.specInfo.getAutoFillProviders();
        if (set == null || set.isEmpty()) {
            return;
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        List<AutofillProviderType> list = this.specInfo.newSpec.getAutofillProviders().getProvider();
        for (AutofillProviderType object : list) {
            treeMap.put(object.getName(), object.getJavaClass());
        }
        for (String string : set) {
            treeMap.put(string, string);
        }
        list.clear();
        for (Map.Entry entry : treeMap.entrySet()) {
            AutofillProviderType autofillProviderType = new AutofillProviderType();
            autofillProviderType.setName((String)entry.getKey());
            autofillProviderType.setJavaClass((String)entry.getValue());
            list.add(autofillProviderType);
        }
    }

    void processOldSpec() throws Exception {
        System.out.print("Processing old spec...");
        OldSpecificationHandler oldSpecificationHandler = new OldSpecificationHandler(this.specInfo);
        oldSpecificationHandler.process();
        OldSpecParser oldSpecParser = new OldSpecParser(this.oldSpecPath, this.specInfo);
        oldSpecParser.parse();
        System.out.println(" done.");
    }

    void mergeCustomFields() {
        System.out.println("Merging custom fields...");
        CustomFieldHandler customFieldHandler = new CustomFieldHandler(this.specInfo);
        customFieldHandler.mergeCustomFields();
        System.out.println("Finished merging custom fields.");
    }

    void mergeOptions() {
        System.out.println("Merging field options...");
        OptionHandler optionHandler = new OptionHandler(this.specInfo);
        optionHandler.process();
        System.out.println("Finished merging field options.");
    }

    void processAttributes(SpecInfo specInfo, NewSpecInfo newSpecInfo) {
        System.out.print("Processing attributes...");
        AttributeHandler attributeHandler = new AttributeHandler(specInfo, newSpecInfo);
        attributeHandler.process();
        System.out.println(" done.");
    }

    void createCustomFieldDataTypeMapping(Specification specification) throws Exception {
        System.out.print("Creating custom field data type mapping...");
        CustomFieldDataTypeMappingHandler customFieldDataTypeMappingHandler = new CustomFieldDataTypeMappingHandler(specification);
        customFieldDataTypeMappingHandler.process();
        System.out.println(" done.");
        System.out.print("Writing custom field data type mapping to " + this.cfDataTypeMappingOutPath + " ...");
        Map<String, String> map = customFieldDataTypeMappingHandler.getDataTypeMap();
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.cfDataTypeMappingOutPath));
        for (Map.Entry<String, String> entry : map.entrySet()) {
            bufferedWriter.write(entry.getKey() + ", " + entry.getValue());
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
        System.out.println(" done.");
    }

    SpecInfo loadSpecs(String string) throws Exception {
        SpecInfo specInfo = new SpecInfo();
        SpecificationJaxbService specificationJaxbService = new SpecificationJaxbService();
        System.out.print("Loading new spec template from a jar...");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(SpecConverter.class.getClassLoader().getResourceAsStream(FILE_NAME_NEW_SPEC)));
        specInfo.newSpec = specificationJaxbService.unmarshal(bufferedReader);
        System.out.println(" done.");
        System.out.print("Loading old spec from " + string + " ...");
        specInfo.oldSpec = specificationJaxbService.unmarshal(string);
        System.out.println(" done.");
        return specInfo;
    }

    void writeSpec(Specification specification, String string) throws Exception {
        System.out.print("Writing new spec to " + this.newSpecOutPath + " ...");
        SpecificationJaxbService specificationJaxbService = new SpecificationJaxbService();
        specificationJaxbService.marshal(specification, string);
        System.out.println(" done.");
    }
}

