/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms;

import com.ericsson.cms.Scheduler;
import com.ericsson.cms.hibernate.HibernateUtil;
import com.ericsson.cms.scheduler.entities.Job;
import com.ericsson.cms.sites.core.entities.DistributionOption;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.LogicalSite;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;

public class SiteManager {
    private static final Logger logger = Logger.getLogger(SiteManager.class);
    private static final String ASSOCIATED_ENTITY_TYPE_SITE_TIMER = "sitetimer";

    public static List<DistributionSite> getDistSites() {
        Query query = SiteManager.getSession().createQuery("from DistributionSite");
        List list = query.list();
        return list == null ? new ArrayList(0) : list;
    }

    public static DistributionSite getDistSite(int n) {
        Query query = SiteManager.getSession().createQuery("from DistributionSite where id = ?");
        query.setInteger(0, n);
        return (DistributionSite)query.uniqueResult();
    }

    public static List<LogicalSite> getLogicalSites() {
        Query query = SiteManager.getSession().createQuery("from LogicalSite");
        List list = query.list();
        return list == null ? new ArrayList(0) : list;
    }

    public static String findNonExistingSiteName(String string) {
        String string2 = string;
        int n = 0;
        while (SiteManager.isSiteExistWithName(string2)) {
            logger.info((Object)("A site with name: " + string2 + " already exists"));
            string2 = string + " " + ++n;
        }
        return string2;
    }

    public static boolean isSiteExistWithName(String string) {
        Query query = SiteManager.getSession().createQuery("from Site where name = ?");
        query.setString(0, string);
        return query.uniqueResult() != null;
    }

    public static DistributionSite inactivateDistSite(int n) {
        DistributionSite distributionSite = SiteManager.getDistSite(n);
        if (distributionSite.isActive()) {
            List<Job> list;
            logger.info((Object)("Distribution Site: [" + distributionSite + "] was active. Making it inactive."));
            distributionSite.setActive(false);
            SiteManager.getSession().save((Object)distributionSite);
            if (distributionSite.getDistributionOption() == DistributionOption.TIMED && (list = Scheduler.getJobsOfAssociatedEntity(ASSOCIATED_ENTITY_TYPE_SITE_TIMER, n)) != null) {
                for (Job job : list) {
                    logger.info((Object)("Inactivating timer job: " + job));
                    Scheduler.inactivate(job.getId());
                }
            }
        } else {
            logger.info((Object)("Distribution Site: [" + distributionSite + "] was already inactive."));
        }
        return distributionSite;
    }

    public static boolean isDistSiteExistWithId(int n) {
        Query query = SiteManager.getSession().createQuery("from DistributionSite where id = ?");
        query.setInteger(0, n);
        return query.uniqueResult() != null;
    }

    private static Session getSession() {
        return HibernateUtil.getSessionFactory().getCurrentSession();
    }
}

