/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.entities;

import com.tandbergtv.watchpoint.pmm.entities.ContainerProperty;
import com.tandbergtv.watchpoint.pmm.entities.ContainerType;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Context {
    private long id;
    private ContainerType containerType;
    private List<ContainerProperty> properties = new ArrayList<ContainerProperty>();

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    public ContainerType getContainerType() {
        return this.containerType;
    }

    public void setContainerType(ContainerType containerType) {
        this.containerType = containerType;
    }

    public IContainer getContainer() {
        return null;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (int)(this.id ^ this.id >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Context context = (Context)object;
        return this.id == context.id;
    }

    public List<ContainerProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<ContainerProperty> list) {
        this.properties = list;
    }

    public void updateProperties(List<ContainerProperty> list) {
        if (list == null || list.isEmpty()) {
            this.properties.clear();
            return;
        }
        Iterator<ContainerProperty> iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            if (this.get(iterator.next().getName(), list) != null) continue;
            iterator.remove();
        }
        for (ContainerProperty containerProperty : list) {
            this.addProperty(containerProperty.getName(), containerProperty.getValue());
        }
    }

    private ContainerProperty get(String string, List<ContainerProperty> list) {
        for (ContainerProperty containerProperty : list) {
            if (!containerProperty.getName().equals(string)) continue;
            return containerProperty;
        }
        return null;
    }

    public void addProperty(String string, String string2) {
        if (string == null || string.isEmpty()) {
            return;
        }
        ContainerProperty containerProperty = this.propertyExists(string);
        if (containerProperty != null) {
            containerProperty.setValue(string2);
        } else {
            this.properties.add(new ContainerProperty(string, string2, this));
        }
    }

    public void removeProperty(String string) {
        ContainerProperty containerProperty = this.propertyExists(string);
        if (containerProperty != null) {
            this.properties.remove(containerProperty);
        }
    }

    public ContainerProperty propertyExists(String string) {
        for (ContainerProperty containerProperty : this.properties) {
            if (!containerProperty.getName().equalsIgnoreCase(string)) continue;
            return containerProperty;
        }
        return null;
    }
}

