/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.upgrade;

import com.ericsson.cms.upgrade.utils.DBUtils;
import java.sql.Connection;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SiteMetadataFormatUpdater {
    protected static final Logger logger = Logger.getLogger(SiteMetadataFormatUpdater.class);
    protected static final String SQL_UPDATE_SITE_METADATA_FORMAT = "update sites_site set metadata_format = 'CL1_1' where metadata_format = 'CableLabsVOD1.1'";

    public static void main(String[] args) throws Exception {
        logger.info((Object)"In SiteMetadataFormatUpdater.main()...");
        SiteMetadataFormatUpdater smfUpdater = new SiteMetadataFormatUpdater();
        smfUpdater.updateSiteMetadataFormat(args);
    }

    public void updateSiteMetadataFormat(String[] args) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DBUtils.getDBConnection(args);
            stmt = conn.createStatement();
            String updateSQL = SQL_UPDATE_SITE_METADATA_FORMAT;
            logger.info((Object)("updateSQL = " + updateSQL));
            int updateCount = stmt.executeUpdate(updateSQL);
            logger.info((Object)("Metadata Format changed to CL1_1 from CableLabsVOD1.1 for " + updateCount + " sites..."));
        }
        catch (Exception e) {
            logger.error((Object)"Exception occurred while updating Metadata Format for sites", (Throwable)e);
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (Exception e1) {
                    logger.error((Object)"Exception rolling back any Site Metadata Formats already updated.", (Throwable)e1);
                }
            }
            throw e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Exception occurred while closing database statement after update Metadata Format", (Throwable)e);
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Exception occurred while closing database connection after update Metadata Format", (Throwable)e);
            }
        }
    }
}

