/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.upgrade;

import com.ericsson.cms.sites.distribution.jaxb.DistributionTemplates;
import com.ericsson.cms.upgrade.utils.DBUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;

public class TemplateUpgradeDBManager {
    protected static final Logger logger = Logger.getLogger(TemplateUpgradeDBManager.class);
    protected static final String DEFAULT_OPT_PATH = "/";
    protected static final String DIST_TEMPLATES_XML_FILE_PATH = "opt/tandbergtv/cms/conf/site/dist-templates.xml";
    protected static final List<String> ANNOTATIONS_LIST = Arrays.asList("ContentProcessing", "LocalContentProcessing", "TitleListProcessing");
    protected static final String EXPRESSION_PREFIX = "@Category(\"";
    protected static final String EXPRESSION_SUFFIX = "\")";
    protected static final String ACTION_NAME_PREFIX = "annotation-";
    protected static final String[] DB_CONN_ARGS = null;

    public static void main(String[] args) throws Exception {
        logger.info((Object)"In TemplateUpgradeDBManager.main()...");
        String optPath = DEFAULT_OPT_PATH;
        if (args != null && args.length > 0 && (optPath = args[0]) != null && optPath.trim().length() > 0) {
            optPath = optPath.trim();
            logger.info((Object)("opt path: '" + optPath + "' was passed in program arguments, and will be used to look up dist-templates.xml..."));
        }
        TemplateUpgradeDBManager templateUpgradeDBManager = new TemplateUpgradeDBManager();
        templateUpgradeDBManager.annotateTemplates(optPath);
    }

    public void annotateTemplates(String optPath) throws Exception {
        logger.info((Object)"Begin annotating templates...");
        List<String> allTemplateNames = this.getAllTemplateNames();
        List<String> distTemplateNames = this.getDistTemplateNames(optPath);
        logger.info((Object)("Distribution Template Names: " + distTemplateNames));
        List<String> remainderTemplateNames = this.subtractList(allTemplateNames, distTemplateNames);
        logger.info((Object)("Templates which are not Distribution Templates: " + remainderTemplateNames));
        if (!remainderTemplateNames.isEmpty()) {
            this.annotateTemplates(remainderTemplateNames);
        } else {
            logger.info((Object)"No templates other than Distribution Templates were found. No annotations would be inserted...");
        }
        logger.info((Object)"End annotating templates...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotateTemplates(List<String> templateNames) {
        if (templateNames != null && !templateNames.isEmpty()) {
            Connection conn = null;
            try {
                conn = this.getConnection(DB_CONN_ARGS);
                conn.setAutoCommit(false);
                for (String templateName : templateNames) {
                    this.annotateTemplate(conn, templateName);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Exception annotating templates", (Throwable)e);
                logger.info((Object)"Any annotations inserted are being rolled back.");
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (Exception e1) {
                        logger.error((Object)"Exception rolling back annotations already inserted", (Throwable)e);
                    }
                }
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Exception occured trying to close db connection after annotating templates", (Throwable)e);
                    }
                }
            }
        }
    }

    public void annotateTemplate(Connection conn, String templateName) throws SQLException {
        for (String annotation : ANNOTATIONS_LIST) {
            String expression = this.getExpression(annotation);
            String actionName = this.getActionName(expression);
            this.annotateTemplate(conn, templateName, expression, actionName);
        }
    }

    public void annotateTemplate(Connection conn, String templateName, String expression, String actionName) throws SQLException {
        String inputParamsStr = "templateName = " + templateName + ", name = " + actionName + ", expression = " + expression;
        logger.debug((Object)("Annotating template: " + inputParamsStr));
        if (conn != null) {
            Statement stmt = null;
            String insertSQL = "insert into jbpm_action (class, name_, expression_, ispropagationallowed_, isasync_, processdefinition_) \r\nselect 'X', '" + actionName + "', '" + expression + "', 1, 0, jp.id_ \r\n" + "from jbpm_processdefinition jp\r\n" + "where upper(jp.name_) = '" + templateName.toUpperCase() + "'\r\n" + "and 0 = (select count(*) from jbpm_action\r\n" + "         where expression_ = '" + expression + "'\r\n" + "         and name_ = '" + actionName + "'\r\n" + "         and processdefinition_ = jp.id_)\r\n" + "and jp.id_ = (select max(jp2.id_) from jbpm_processdefinition jp2\r\n" + "              where upper(jp2.name_) = '" + templateName.toUpperCase() + "'\r\n" + "              group by upper(jp2.name_))\r\n";
            logger.debug((Object)("insertSQL = " + insertSQL));
            try {
                stmt = conn.createStatement();
                int rowsInserted = stmt.executeUpdate(insertSQL);
                logger.info((Object)(rowsInserted + " template annotation" + (rowsInserted == 1 ? "" : "s") + " inserted for " + inputParamsStr));
            }
            catch (SQLException se) {
                logger.error((Object)("Exception inserting template annotation for " + inputParamsStr), (Throwable)se);
                throw se;
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException se) {
                        logger.warn((Object)("Exception occured closing DB Statement for insertSQL = " + insertSQL), (Throwable)se);
                    }
                }
            }
        }
        logger.error((Object)"Got 'null' DB connection. Cannot insert template annotation...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllTemplateNames() {
        ArrayList<String> allTemplateNames = new ArrayList<String>();
        logger.debug((Object)"Getting all templates names...");
        Connection conn = null;
        Statement stmt = null;
        String sql = "select distinct name_ from jbpm_processdefinition\r\nwhere processdefinitiontypeid = 2\r\n";
        logger.debug((Object)("sql = " + sql));
        try {
            conn = this.getConnection(DB_CONN_ARGS);
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String templateName = rs.getString("name_");
                allTemplateNames.add(templateName);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception annotating templates", (Throwable)e);
            logger.info((Object)"Any annotations inserted are being rolled back.");
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (Exception e1) {
                    logger.error((Object)"Exception rolling back annotations already inserted", (Throwable)e);
                }
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    logger.warn((Object)("Exception occured closing DB Statement for insertSQL = " + sql), (Throwable)e);
                }
            }
        }
        logger.debug((Object)("Got following template names: " + allTemplateNames));
        return allTemplateNames;
    }

    public List<String> subtractList(List<String> lhsList, List<String> listToSubtract) {
        ArrayList<String> remainderList = new ArrayList<String>(lhsList);
        for (String s : listToSubtract) {
            if (!remainderList.contains(s)) continue;
            remainderList.remove(s);
        }
        return remainderList;
    }

    public String getExpression(String annotation) {
        String expression = null;
        if (annotation != null && !annotation.isEmpty()) {
            expression = EXPRESSION_PREFIX + annotation + EXPRESSION_SUFFIX;
        }
        return expression;
    }

    public String getActionName(String expression) {
        String actionName = null;
        if (expression != null && !expression.isEmpty()) {
            actionName = ACTION_NAME_PREFIX + expression;
        }
        return actionName;
    }

    public List<String> getDistTemplateNames(String optPath) throws Exception {
        ArrayList<String> distTemplateNames = new ArrayList<String>();
        logger.debug((Object)"Getting distribution templates names...");
        String distTemplatesFilePath = null;
        try {
            File distTemplatesFile = new File(optPath, DIST_TEMPLATES_XML_FILE_PATH);
            distTemplatesFilePath = distTemplatesFile.getAbsolutePath();
            logger.info((Object)("Getting distribution templates list from file: " + distTemplatesFilePath));
            if (distTemplatesFile.exists()) {
                if (distTemplatesFile.canRead()) {
                    String jaxbPackageName = "com.ericsson.cms.sites.distribution.jaxb";
                    JAXBContext jc = JAXBContext.newInstance((String)jaxbPackageName);
                    Unmarshaller u = jc.createUnmarshaller();
                    DistributionTemplates distTemplates = (DistributionTemplates)u.unmarshal(distTemplatesFile);
                    for (DistributionTemplates.DistributionTemplate distTemplate : distTemplates.getDistributionTemplate()) {
                        String distTemplateName = distTemplate.getTemplateName();
                        distTemplateNames.add(distTemplateName);
                    }
                } else {
                    logger.warn((Object)("Cannot read dist-templates.xml at location: " + distTemplatesFilePath));
                }
            } else {
                logger.warn((Object)("dist-templates.xml does not exist at location: " + distTemplatesFilePath));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Got exception getting distribution template names from file: " + distTemplatesFilePath), (Throwable)e);
            throw e;
        }
        return distTemplateNames;
    }

    public void copyFile(File sourceFile, File destFile) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(sourceFile);
        FileOutputStream out = new FileOutputStream(destFile);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    protected Connection getConnection(String[] args) throws Exception {
        return DBUtils.getDBConnection(args);
    }
}

