/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.upgrade.utils;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DBUtils {
    public static final String JDBC_DEFAULT_CONN_STRING = "jdbc:oracle:thin:@{0}:{1}:{2}";
    protected static final Logger logger = Logger.getLogger(DBUtils.class);
    protected static final String DEFAULT_USERNAME = "wfs";
    protected static final String DEFAULT_PASSWORD = "Wf$1234";
    protected static final String DEFAULT_SID = "ttv";
    protected static final String DEFAULT_HOSTNAME = "DBSERVER";
    protected static final String DEFAULT_PORT = "1521";
    protected static final String DEFAULT_JDBC_DRIVER_CLASS = "oracle.jdbc.driver.OracleDriver";
    protected static final String KEY_DB_TYPE = "db.type";
    protected static final String KEY_URL_PREFIX = "url";
    protected static final String KEY_DRIVER_PREFIX = "driver";
    protected static final String KEY_PORT_PREFIX = "port";
    protected static final String KEY_USERNAME_PREFIX = "username";
    protected static final String KEY_PASSWORD_PREFIX = "password";
    protected static final String KEY_SID_PREFIX = "sid";
    protected static final String KEY_HOST_PREFIX = "host";
    protected static Connection dbConn = null;

    public static Connection getDBConnection(String[] args) {
        if (dbConn == null) {
            logger.info((Object)"dbConn is 'null'. Getting a new database Connection...");
            dbConn = DBUtils.getConnection(args);
        }
        return dbConn;
    }

    protected static Connection getConnection(String[] args) {
        String hostName;
        String host = DEFAULT_HOSTNAME;
        String sid = DEFAULT_SID;
        String userName = DEFAULT_USERNAME;
        String password = DEFAULT_PASSWORD;
        String jdbcURL = JDBC_DEFAULT_CONN_STRING;
        String driverClass = DEFAULT_JDBC_DRIVER_CLASS;
        String port = DEFAULT_PORT;
        Properties p = null;
        String argsString = Arrays.toString(args);
        logger.info((Object)("Getting " + sid + " database connection...args: " + argsString));
        Connection conn = null;
        if (args != null && args.length > 0 && (hostName = args[0]) != null && hostName.trim().length() > 0) {
            hostName = hostName.trim();
            logger.info((Object)("Hostname: " + hostName + " was passed in program arguments, and will be used instead of " + host));
            host = hostName;
        }
        try {
            p = DBUtils.loadProperties();
            DbType dbType = DbType.valueOf(p.getProperty(KEY_DB_TYPE, DbType.ORACLE.dbString));
            jdbcURL = p.getProperty("url." + (Object)((Object)dbType), jdbcURL).trim();
            driverClass = p.getProperty("driver." + (Object)((Object)dbType), driverClass).trim();
            host = p.getProperty("host." + (Object)((Object)dbType), host).trim();
            sid = p.getProperty("sid." + (Object)((Object)dbType), sid).trim();
            port = p.getProperty("port." + (Object)((Object)dbType), port).trim();
            userName = p.getProperty(KEY_USERNAME_PREFIX, userName).trim();
            password = p.getProperty("password." + (Object)((Object)dbType), password).trim();
        }
        catch (Exception e) {
            logger.warn((Object)("Reading db properties failed, error:" + e.getMessage() + " using default values..."));
        }
        logger.info((Object)("Getting database connection for jdbcURL = " + jdbcURL));
        String connURL = null;
        try {
            Class.forName(driverClass);
            MessageFormat format = new MessageFormat(jdbcURL);
            conn = DriverManager.getConnection(format.format(new Object[]{host, port, sid}), userName, password);
            connURL = conn.getMetaData().getURL();
        }
        catch (Exception e) {
            String errMsg = "Exception occurred getting connection for jdbcURL: " + jdbcURL + " : " + e.toString();
            logger.error((Object)errMsg, (Throwable)e);
            throw new RuntimeException(errMsg, e);
        }
        logger.info((Object)("Returning " + sid + " database connection...URL: " + connURL));
        return conn;
    }

    private static Properties loadProperties() throws IOException {
        Properties p = new Properties();
        p.load(DBUtils.class.getClassLoader().getResourceAsStream("/db.properties"));
        return p;
    }

    public static enum DbType {
        ORACLE("oracle"),
        EDB("edb");

        private final String dbString;

        private DbType(String dbString) {
            this.dbString = dbString;
        }

        public String toString() {
            return this.dbString;
        }
    }
}

