/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.partner;

import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.content.contentclass.hibernate.ContentClassHibernateFactory;
import com.tandbergtv.content.contentclass.hibernate.ContentClassPartnerEntity;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.type.Type;

public class ContentClassServiceHibernate {
    private static Logger logger = Logger.getLogger(ContentClassServiceHibernate.class);
    private static SessionFactory sessionFactory;
    private Session session = null;
    private Transaction tx = null;

    public void init() {
        sessionFactory = new Configuration().configure("resources/hibernate.cfg.xml").buildSessionFactory();
        this.session = sessionFactory.openSession();
    }

    public void beginTransaction() {
        this.tx = this.session.beginTransaction();
    }

    public void commit() {
        this.tx.commit();
    }

    public void rollback() {
        this.tx.rollback();
    }

    public void closeSession() {
        if (this.session != null) {
            this.session.close();
        }
    }

    public List<ContentClass> getAllContentClassesWithoutMetadata() throws ContentClassPersistenceException {
        try {
            Session session = this.getCurrentSession();
            String string = "select id, typeId, name, description, specialUsageId, isDefault from ContentClassEntity";
            Query query = session.createQuery(string);
            List list = query.list();
            if (list == null || list.isEmpty()) {
                return null;
            }
            return this.createContentClassList(list);
        }
        catch (Exception exception) {
            String string = "Unable to get a list of content classes";
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, (Throwable)exception);
        }
    }

    private Session getCurrentSession() {
        if (this.session == null) {
            this.session = sessionFactory.openSession();
        }
        return this.session;
    }

    public List<ContentClassPartner> getAllContentClassPartnersWithoutMetadata() throws ContentClassPersistenceException {
        ArrayList<ContentClassPartner> arrayList = new ArrayList<ContentClassPartner>();
        try {
            Session session = this.getCurrentSession();
            String string = "select content_class_id, partner_id from pmm_content_class_partner";
            SQLQuery sQLQuery = session.createSQLQuery(string);
            sQLQuery.addScalar("content_class_id", (Type)Hibernate.LONG);
            sQLQuery.addScalar("partner_id", (Type)Hibernate.LONG);
            List list = sQLQuery.list();
            if (list != null && !list.isEmpty()) {
                for (Object e : list) {
                    Object[] objectArray = (Object[])e;
                    ContentClassPartner contentClassPartner = new ContentClassPartner(((Long)objectArray[0]).longValue(), ((Long)objectArray[1]).longValue());
                    arrayList.add(contentClassPartner);
                }
            }
        }
        catch (Exception exception) {
            String string = "Unable to get a list of content class partners";
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, (Throwable)exception);
        }
        return arrayList;
    }

    public List<ContentClass> getPartnerContentClassesWithoutMetadata(long l) throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String string = "select c.id, c.typeId, c.name, c.description, c.specialUsageId, c.isDefault from ContentClassEntity c, ContentClassPartnerEntity p  where c.id = p.contentClassId and p.partnerId = ?";
            Query query = session.createQuery(string);
            query.setLong(0, l);
            List list = query.list();
            if (list == null || list.isEmpty()) {
                return null;
            }
            return this.createContentClassList(list);
        }
        catch (Exception exception) {
            String string = "Unable to get a list of content classes";
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, (Throwable)exception);
        }
    }

    private List<ContentClass> createContentClassList(List list) {
        if (list == null) {
            return null;
        }
        ArrayList<ContentClass> arrayList = new ArrayList<ContentClass>();
        for (int i = 0; i < list.size(); ++i) {
            Object[] objectArray = (Object[])list.get(i);
            ContentClass contentClass = new ContentClass();
            contentClass.setId(((Long)objectArray[0]).longValue());
            int n = (Integer)objectArray[1];
            switch (n) {
                case 0: {
                    contentClass.setType(ContentClass.Type.Package);
                    break;
                }
                case 1: {
                    contentClass.setType(ContentClass.Type.Series);
                    break;
                }
                case 2: {
                    contentClass.setType(ContentClass.Type.Category);
                    break;
                }
                default: {
                    contentClass.setType(ContentClass.Type.Package);
                }
            }
            contentClass.setName((String)objectArray[2]);
            contentClass.setDescription((String)objectArray[3]);
            int n2 = (Integer)objectArray[4];
            switch (n2) {
                case 1: {
                    contentClass.setSpecialUsage(ContentClass.SpecialUsage.PreRoll);
                    break;
                }
                case 2: {
                    contentClass.setSpecialUsage(ContentClass.SpecialUsage.PostRoll);
                    break;
                }
                default: {
                    contentClass.setSpecialUsage(ContentClass.SpecialUsage.None);
                }
            }
            contentClass.setDefault(((Boolean)objectArray[5]).booleanValue());
            arrayList.add(contentClass);
        }
        return arrayList;
    }

    public ContentClassPartner getContentClassPartnerMetadata(long l, long l2) throws ContentClassPersistenceException {
        try {
            Object var5_3 = null;
            Session session = this.getCurrentSession();
            ContentClassPartnerEntity contentClassPartnerEntity = new ContentClassPartnerEntity(l, l2);
            contentClassPartnerEntity = (ContentClassPartnerEntity)session.get(ContentClassPartnerEntity.class, (Serializable)contentClassPartnerEntity);
            if (contentClassPartnerEntity == null) {
                return null;
            }
            session.evict((Object)contentClassPartnerEntity);
            return ContentClassHibernateFactory.createContentClassPartner((ContentClassPartnerEntity)contentClassPartnerEntity);
        }
        catch (Exception exception) {
            String string = "Unable to get content class partner with contentClassId = " + l + "and partnerId = " + l2;
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, (Throwable)exception);
        }
    }

    public void saveContentClassPartner(ContentClassPartner contentClassPartner) throws ContentClassPersistenceException {
        if (contentClassPartner == null) {
            return;
        }
        try {
            Session session = this.getCurrentSession();
            ContentClassPartnerEntity contentClassPartnerEntity = ContentClassHibernateFactory.createContentClassPartnerEntity((ContentClassPartner)contentClassPartner);
            session.saveOrUpdate((Object)contentClassPartnerEntity);
        }
        catch (Exception exception) {
            String string = "Unable to save a content class partner with contentClassId = " + contentClassPartner.getContentClassId() + "and partnerId = " + contentClassPartner.getPartnerId();
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, (Throwable)exception);
        }
    }
}

