/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.reports;

import com.tandbergtv.reports.Report;
import com.tandbergtv.reports.ReportCategory;
import com.tandbergtv.reports.Reports;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class ReportConfigMergeManager {
    public File getConfigFile() throws IOException {
        File config = null;
        URL pUrl = this.getClass().getResource("/resources/config.properties");
        Properties p = new Properties();
        p.load(pUrl.openStream());
        config = new File(p.getProperty("report_config_file"));
        return config;
    }

    public static void parseCustomerConfig(File configFile) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Reports.class});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        Reports reports = (Reports)unmarshaller.unmarshal(configFile);
        List<ReportCategory> categoryList = reports.getReportCategory();
        List<Report> trendingReports = ReportConfigMergeManager.getTrendingCategoryReports();
        ReportConfigMergeManager.mergeTrendingCategory(categoryList, trendingReports);
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)reports, configFile);
    }

    private static void mergeTrendingCategory(List<ReportCategory> categoryList, List<Report> trendingReports) {
        for (ReportCategory reportCategory : categoryList) {
            if (!reportCategory.getCName().equalsIgnoreCase("Trending Reports")) continue;
            List<Report> reportList = reportCategory.getReport();
            reportList.addAll(trendingReports);
            ReportConfigMergeManager.removeDuplicates(reportList);
        }
    }

    private static void removeDuplicates(List<Report> reportList) {
        HashSet<Report> h = new HashSet<Report>(reportList);
        reportList.clear();
        reportList.addAll(h);
    }

    private static List<Report> getTrendingCategoryReports() throws JAXBException {
        List<Report> reportList = new ArrayList<Report>();
        List<Object> categoryList = new ArrayList();
        File commonConfigFile = new File("resources/reports_common_config.xml");
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Reports.class});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        Reports reports = (Reports)unmarshaller.unmarshal(commonConfigFile);
        categoryList = reports.getReportCategory();
        for (ReportCategory reportCategory : categoryList) {
            if (!reportCategory.getCName().equalsIgnoreCase("Trending Reports")) continue;
            reportList = reportCategory.getReport();
        }
        return reportList;
    }

    private static List<ReportCategory> getTrendingCategories() throws JAXBException {
        ArrayList<ReportCategory> categoryList = new ArrayList();
        File commonConfigFile = new File("resources/reports_common_config.xml");
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Reports.class});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        Reports reports = (Reports)unmarshaller.unmarshal(commonConfigFile);
        categoryList = reports.getReportCategory();
        return categoryList;
    }

    public static void main(String[] args) {
        Properties prop = new Properties();
        File customerReportConfigFile = null;
        try {
            prop.load(new FileInputStream("resources/config.properties"));
            customerReportConfigFile = new File(prop.getProperty("report_config_file"));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (customerReportConfigFile != null) {
            try {
                ReportConfigMergeManager.parseCustomerConfig(customerReportConfigFile);
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        }
    }
}

