/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.converter.autofill;

import com.ericsson.converter.autofill.AutofillProvider;
import com.ericsson.converter.util.DBUtils;
import com.ericsson.converter.util.DbUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class AutofillProviderService {
    private static Logger logger = Logger.getLogger(AutofillProviderService.class);
    private static final String GROUP_DELETE = "delete from cms_setting_group where group_path = 'com.ericsson.cms.contentmgmt.autofill'";
    private static final String GROUP_INSERT = "insert into cms_setting_group(group_path, parent_path) values(?, ?)";
    private static final String GROUP_GET_ID = "select settinggroupid from cms_setting_group where group_path = 'com.ericsson.cms.contentmgmt.autofill'";
    private static final String PROVIDER_INSERT = "insert into cms_setting(setting_name, setting_value, cms_setting_group_id) values(?, ?, ?)";

    public void save(List<AutofillProvider> list) throws Exception {
        int n = this.getGroupId();
        if (n < 0) {
            this.insertGroup("com.ericsson.cms.contentmgmt.autofill", "com.ericsson.cms.contentmgmt");
            n = this.getGroupId();
        }
        this.insertProviders(n, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getGroupId() throws Exception {
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block2: {
            int n;
            connection = null;
            statement = null;
            resultSet = null;
            try {
                connection = DBUtils.getDBConnection(null);
                statement = connection.createStatement();
                resultSet = statement.executeQuery(GROUP_GET_ID);
                if (!resultSet.next()) break block2;
                n = resultSet.getInt(1);
            }
            catch (Throwable throwable) {
                DbUtil.close(resultSet);
                DbUtil.close(statement);
                DbUtil.close(connection);
                throw throwable;
            }
            DbUtil.close(resultSet);
            DbUtil.close(statement);
            DbUtil.close(connection);
            return n;
        }
        DbUtil.close(resultSet);
        DbUtil.close(statement);
        DbUtil.close(connection);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertGroup(String string, String string2) throws Exception {
        logger.info((Object)("Inserting settings group. Name = " + string + ", parent = " + string2));
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = DBUtils.getDBConnection(null);
            connection.setAutoCommit(true);
            preparedStatement = connection.prepareStatement(GROUP_INSERT);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            DbUtil.close(preparedStatement);
            DbUtil.close(connection);
            throw throwable;
        }
        DbUtil.close(preparedStatement);
        DbUtil.close(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertProviders(int n, List<AutofillProvider> list) throws Exception {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = DBUtils.getDBConnection(null);
            connection.setAutoCommit(true);
            preparedStatement = connection.prepareStatement(PROVIDER_INSERT);
            for (int i = 0; i < list.size(); ++i) {
                AutofillProvider autofillProvider = list.get(i);
                String string = "providers.provider[" + i + "].displayName";
                this.insertSetting(preparedStatement, string, autofillProvider.displayName, n);
                string = "providers.provider[" + i + "].javaClass";
                this.insertSetting(preparedStatement, string, autofillProvider.javaClass, n);
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(preparedStatement);
            DbUtil.close(connection);
            throw throwable;
        }
        DbUtil.close(preparedStatement);
        DbUtil.close(connection);
    }

    private void insertSetting(PreparedStatement preparedStatement, String string, String string2, int n) throws Exception {
        logger.info((Object)("Inserting setting. Name = " + string + ", value = " + string2));
        try {
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.setInt(3, n);
            preparedStatement.executeUpdate();
        }
        catch (SQLIntegrityConstraintViolationException sQLIntegrityConstraintViolationException) {
            logger.info((Object)"Setting already exists");
        }
    }
}

