/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.converter.util;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DBUtils {
    public static final String JDBC_DEFAULT_CONN_STRING = "jdbc:oracle:thin:@{0}:{1}:{2}";
    protected static final Logger logger = Logger.getLogger(DBUtils.class);
    protected static final String DEFAULT_USERNAME = "wfs";
    protected static final String DEFAULT_PASSWORD = "Wf$1234";
    protected static final String DEFAULT_SID = "ttv";
    protected static final String DEFAULT_HOSTNAME = "DBSERVER";
    protected static final String DEFAULT_PORT = "1521";
    protected static final String DEFAULT_JDBC_DRIVER_CLASS = "oracle.jdbc.driver.OracleDriver";
    protected static final String KEY_DB_TYPE = "db.type";
    protected static final String KEY_URL_PREFIX = "url";
    protected static final String KEY_DRIVER_PREFIX = "driver";
    protected static final String KEY_PORT_PREFIX = "port";
    protected static final String KEY_USERNAME_PREFIX = "username";
    protected static final String KEY_PASSWORD_PREFIX = "password";
    protected static final String KEY_SID_PREFIX = "sid";
    protected static final String KEY_HOST_PREFIX = "host";
    protected static Connection dbConn = null;

    public static Connection getDBConnection(String[] stringArray) {
        if (dbConn == null) {
            logger.info((Object)"dbConn is 'null'. Getting a new database Connection...");
            dbConn = DBUtils.getConnection(stringArray);
        }
        return dbConn;
    }

    protected static Connection getConnection(String[] stringArray) {
        Object object;
        Object object2 = DEFAULT_HOSTNAME;
        String string = DEFAULT_SID;
        String string2 = DEFAULT_USERNAME;
        String string3 = DEFAULT_PASSWORD;
        String string4 = JDBC_DEFAULT_CONN_STRING;
        String string5 = DEFAULT_JDBC_DRIVER_CLASS;
        String string6 = DEFAULT_PORT;
        Properties properties = null;
        String string7 = Arrays.toString(stringArray);
        logger.info((Object)("Getting " + string + " database connection...args: " + string7));
        Connection connection = null;
        if (stringArray != null && stringArray.length > 0 && (object = stringArray[0]) != null && ((String)object).trim().length() > 0) {
            object = ((String)object).trim();
            logger.info((Object)("Hostname: " + (String)object + " was passed in program arguments, and will be used instead of " + (String)object2));
            object2 = object;
        }
        try {
            properties = DBUtils.loadProperties();
            object = DbType.valueOf(properties.getProperty(KEY_DB_TYPE, DbType.ORACLE.dbString));
            string4 = properties.getProperty("url." + object, string4).trim();
            string5 = properties.getProperty("driver." + object, string5).trim();
            object2 = properties.getProperty("host." + object, (String)object2).trim();
            string = properties.getProperty("sid." + object, string).trim();
            string6 = properties.getProperty("port." + object, string6).trim();
            string2 = properties.getProperty(KEY_USERNAME_PREFIX, string2).trim();
            string3 = properties.getProperty("password." + object, string3).trim();
        }
        catch (Exception exception) {
            logger.warn((Object)("Reading db properties failed, error:" + exception.getMessage() + " using default values..."));
        }
        logger.info((Object)("Getting database connection for jdbcURL = " + string4));
        object = null;
        try {
            Class.forName(string5);
            MessageFormat messageFormat = new MessageFormat(string4);
            connection = DriverManager.getConnection(messageFormat.format(new Object[]{object2, string6, string}), string2, string3);
            object = connection.getMetaData().getURL();
        }
        catch (Exception exception) {
            String string8 = "Exception occurred getting connection for jdbcURL: " + string4 + " : " + exception.toString();
            logger.error((Object)string8, (Throwable)exception);
            throw new RuntimeException(string8, exception);
        }
        logger.info((Object)("Returning " + string + " database connection...URL: " + (String)object));
        return connection;
    }

    private static Properties loadProperties() throws IOException {
        Properties properties = new Properties();
        properties.load(DBUtils.class.getClassLoader().getResourceAsStream("/db.properties"));
        return properties;
    }

    public static enum DbType {
        ORACLE("oracle"),
        EDB("edb");

        private final String dbString;

        private DbType(String string2) {
            this.dbString = string2;
        }

        public String toString() {
            return this.dbString;
        }
    }
}

