/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass;

import com.tandbergtv.content.contentclass.PropertyConverter;
import com.tandbergtv.content.contentclass.SpecAttributeHandler;
import com.tandbergtv.content.contentclass.option.OptionsMerger;
import com.tandbergtv.content.contentclass.spec.FlatSpec;
import com.tandbergtv.content.contentclass.spec.FlatSpecBuilder;
import com.tandbergtv.content.contentclass.util.SpecUtil;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationJaxbService;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.Specification;
import java.io.File;
import java.util.Map;
import org.apache.log4j.Logger;

public class SpecConverter12 {
    private static Logger logger = Logger.getLogger(SpecConverter12.class);
    private String inputFolder;
    private String outputFolder;
    private Specification oldSpec;
    private FlatSpec oldFlatSpec;
    private Specification newSpec;
    private Map<Object, Object> newProps;

    public SpecConverter12(String string, String string2) {
        this.inputFolder = string;
        this.outputFolder = string2;
    }

    public Specification getNewSpec() {
        return this.newSpec;
    }

    public Map<Object, Object> getNewProperties() {
        return this.newProps;
    }

    public void run(String string, String string2) throws Exception {
        File file = new File(this.inputFolder, string);
        if (!file.exists()) {
            logger.error((Object)("Old specification file doesn't exist: " + file.getAbsolutePath()));
            return;
        }
        file = new File(this.inputFolder, string2);
        if (!file.exists()) {
            logger.error((Object)("Old properties file doesn't exist: " + file.getAbsolutePath()));
            return;
        }
        file = new File(this.inputFolder, string);
        this.oldSpec = SpecUtil.loadSpecification(file.getAbsolutePath());
        FlatSpecBuilder flatSpecBuilder = new FlatSpecBuilder(this.oldSpec);
        this.oldFlatSpec = flatSpecBuilder.build();
        this.newSpec = SpecUtil.loadNewSpecificationTemplate(string);
        this.mergeAttributes();
        this.mergeOptions(string);
        this.writeSpec(string);
        PropertyConverter propertyConverter = new PropertyConverter();
        propertyConverter.setInFileName(string2);
        propertyConverter.setOutFileName("ecmf.properties");
        propertyConverter.setTemplateFileName("ecmf.properties");
        propertyConverter.setInFolder(this.inputFolder);
        propertyConverter.setOutFolder(this.outputFolder);
        propertyConverter.process();
        this.newProps = propertyConverter.getProperties();
    }

    void mergeAttributes() throws Exception {
        logger.info((Object)"Merging attributes...");
        SpecAttributeHandler specAttributeHandler = new SpecAttributeHandler(this.oldFlatSpec, this.newSpec);
        specAttributeHandler.run();
        logger.info((Object)"Finished merging attributes.");
    }

    void mergeOptions(String string) throws Exception {
        logger.info((Object)"Merging field options...");
        File file = new File(this.inputFolder, string);
        UISpecification uISpecification = SpecUtil.loadUISpecification(file.getAbsolutePath());
        OptionsMerger optionsMerger = new OptionsMerger();
        optionsMerger.merge(uISpecification, this.newSpec);
        logger.info((Object)"Finished merging field options.");
    }

    private void writeSpec(String string) throws Exception {
        String string2 = null;
        File file = new File(this.outputFolder);
        if (!file.exists()) {
            file.mkdirs();
        }
        string2 = new File(file, string).getAbsolutePath();
        logger.info((Object)("Writing new spec to " + string2));
        SpecificationJaxbService specificationJaxbService = new SpecificationJaxbService();
        specificationJaxbService.marshal(this.newSpec, string2);
        logger.info((Object)"Finished writing new spec.");
    }
}

