/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.watchpoint.pmm.title.conf.AutofillProvider;
import com.tandbergtv.watchpoint.pmm.title.conf.BooleanVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.ComplexVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.DateVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.FloatVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.IVariableOptionProvider;
import com.tandbergtv.watchpoint.pmm.title.conf.IntegerVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.SimpleVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationValidationException;
import com.tandbergtv.watchpoint.pmm.title.conf.StringVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TimeVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import com.tandbergtv.watchpoint.pmm.title.conf.VariableOption;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.AutofillProviderListType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.AutofillProviderType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.BooleanVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.ComplexVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.DateVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.FloatVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.IntegerVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.OptionsType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.SimpleVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.StringVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.TimeVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.TitleType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.VariableType;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class SpecificationReader {
    private static final String NAMESPACE_PREFIX = "";
    private static final String PATH_SEPARATOR = "/";
    private static final String ATTRIBUTE = "@";
    private static final String ROOT_FIELD = "Fields";

    public UISpecification unmarshal(String string, ClassLoader classLoader, ResourceBundle resourceBundle) throws SpecificationValidationException {
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((String)(SpecificationReader.class.getPackage().getName() + ".jaxb"));
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            Specification specification = (Specification)unmarshaller.unmarshal(new File(string));
            return this.convertToSpecification(specification, classLoader, resourceBundle);
        }
        catch (JAXBException jAXBException) {
            throw new SpecificationValidationException(jAXBException);
        }
    }

    public UISpecification unmarshal(InputStream inputStream, ClassLoader classLoader, ResourceBundle resourceBundle) throws SpecificationValidationException {
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((String)(SpecificationReader.class.getPackage().getName() + ".jaxb"));
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            Specification specification = (Specification)unmarshaller.unmarshal(inputStream);
            return this.convertToSpecification(specification, classLoader, resourceBundle);
        }
        catch (JAXBException jAXBException) {
            throw new SpecificationValidationException(jAXBException);
        }
    }

    private UISpecification convertToSpecification(Specification specification, ClassLoader classLoader, ResourceBundle resourceBundle) throws SpecificationValidationException {
        List<AutofillProviderType> list;
        UISpecification uISpecification = new UISpecification();
        uISpecification.setClassLoader(classLoader);
        uISpecification.setBundle(resourceBundle);
        TitleType titleType = specification.getTitle();
        uISpecification.setRootTitleConf(this.convertToTitleConf(uISpecification, titleType, null));
        AutofillProviderListType autofillProviderListType = specification.getAutofillProviders();
        if (autofillProviderListType != null && (list = autofillProviderListType.getProvider()) != null) {
            for (AutofillProviderType autofillProviderType : list) {
                AutofillProvider autofillProvider = new AutofillProvider(autofillProviderType.getName(), autofillProviderType.getJavaClass());
                uISpecification.addAutofillProvider(autofillProvider);
            }
        }
        return uISpecification;
    }

    private TitleConf convertToTitleConf(UISpecification uISpecification, TitleType titleType, TitleConf titleConf) throws SpecificationValidationException {
        Object object;
        Object object2;
        TitleConf titleConf2 = new TitleConf(uISpecification);
        titleConf2.setName(this.trim(titleType.getName()));
        titleConf2.setAlias(titleType.getAlias());
        String string = titleConf == null ? titleConf2.getName() : titleConf.getPath() + PATH_SEPARATOR + titleConf2.getName();
        titleConf2.setPath(string);
        titleConf2.setMaxOccurs(1);
        TitleType.Metadata metadata = titleType.getMetadata();
        if (metadata != null && (object2 = metadata.getVariable()) != null) {
            Iterator<VariableType> object3 = object2.iterator();
            while (object3.hasNext()) {
                ArrayList<VariableType> arrayList;
                object = object3.next();
                Variable variable = this.convertToVariable(uISpecification, titleConf2, (VariableType)object, arrayList = new ArrayList<VariableType>());
                if (variable == null) continue;
                titleConf2.addMetadata(variable);
            }
        }
        if (titleType.getChildTitles() != null && titleType.getChildTitles().getTitle() != null) {
            for (TitleType titleType2 : titleType.getChildTitles().getTitle()) {
                object = this.convertToTitleConf(uISpecification, titleType2, titleConf2);
                titleConf2.addChild((TitleConf)object);
            }
        }
        return titleConf2;
    }

    private Variable convertToVariable(UISpecification uISpecification, TitleConf titleConf, VariableType variableType, List<VariableType> list) throws SpecificationValidationException {
        Variable variable = null;
        if (BooleanVariableType.class.equals(variableType.getClass())) {
            BooleanVariableType booleanVariableType = (BooleanVariableType)variableType;
            variable = this.convertToBooleanVariable(uISpecification, titleConf, booleanVariableType, list);
        } else if (IntegerVariableType.class.equals(variableType.getClass())) {
            IntegerVariableType integerVariableType = (IntegerVariableType)variableType;
            variable = this.convertToIntegerVariable(uISpecification, titleConf, integerVariableType, list);
        } else if (FloatVariableType.class.equals(variableType.getClass())) {
            FloatVariableType floatVariableType = (FloatVariableType)variableType;
            variable = this.convertToFloatVariable(uISpecification, titleConf, floatVariableType, list);
        } else if (DateVariableType.class.equals(variableType.getClass())) {
            DateVariableType dateVariableType = (DateVariableType)variableType;
            variable = this.convertToDateVariable(uISpecification, titleConf, dateVariableType, list);
        } else if (TimeVariableType.class.equals(variableType.getClass())) {
            TimeVariableType timeVariableType = (TimeVariableType)variableType;
            variable = this.convertToTimeVariable(uISpecification, titleConf, timeVariableType, list);
        } else if (StringVariableType.class.equals(variableType.getClass())) {
            StringVariableType stringVariableType = (StringVariableType)variableType;
            variable = this.convertToStringVariable(uISpecification, titleConf, stringVariableType, list);
        } else if (ComplexVariableType.class.equals(variableType.getClass())) {
            ComplexVariableType complexVariableType = (ComplexVariableType)variableType;
            variable = this.convertToComplexVariable(uISpecification, titleConf, complexVariableType, list);
        } else {
            String string = "Failed to convert variable type of class: " + variableType.getClass();
            throw new SpecificationValidationException(string);
        }
        return variable;
    }

    private void convertOptions(UISpecification uISpecification, SimpleVariableType simpleVariableType, SimpleVariable simpleVariable) {
        OptionsType optionsType = simpleVariableType.getOptions();
        if (optionsType != null) {
            simpleVariable.setAnyValueAllowed(optionsType.isAnyValueAllowed());
            simpleVariable.setOptionProvider(optionsType.getOptionProvider());
            int n = optionsType.getOption().size();
            if (n > 0) {
                for (OptionsType.Option option : optionsType.getOption()) {
                    String string = this.getDisplayName(option.getName(), uISpecification.getBundle());
                    simpleVariable.addOption(new VariableOption(string, option.getValue()));
                }
            }
        }
    }

    private Variable convertToBooleanVariable(UISpecification uISpecification, TitleConf titleConf, BooleanVariableType booleanVariableType, List<VariableType> list) throws SpecificationValidationException {
        BooleanVariable booleanVariable = new BooleanVariable(titleConf);
        this.buildSimpleVariable(booleanVariableType, booleanVariable, list);
        this.convertOptions(uISpecification, booleanVariableType, booleanVariable);
        return this.convertChildVariables(uISpecification, titleConf, booleanVariableType, booleanVariable, list);
    }

    private Variable convertToIntegerVariable(UISpecification uISpecification, TitleConf titleConf, IntegerVariableType integerVariableType, List<VariableType> list) throws SpecificationValidationException {
        IntegerVariable integerVariable = new IntegerVariable(titleConf);
        this.buildSimpleVariable(integerVariableType, integerVariable, list);
        this.convertOptions(uISpecification, integerVariableType, integerVariable);
        return this.convertChildVariables(uISpecification, titleConf, integerVariableType, integerVariable, list);
    }

    private Variable convertToFloatVariable(UISpecification uISpecification, TitleConf titleConf, FloatVariableType floatVariableType, List<VariableType> list) throws SpecificationValidationException {
        FloatVariable floatVariable = new FloatVariable(titleConf);
        this.buildSimpleVariable(floatVariableType, floatVariable, list);
        this.convertOptions(uISpecification, floatVariableType, floatVariable);
        return this.convertChildVariables(uISpecification, titleConf, floatVariableType, floatVariable, list);
    }

    private Variable convertToDateVariable(UISpecification uISpecification, TitleConf titleConf, DateVariableType dateVariableType, List<VariableType> list) throws SpecificationValidationException {
        DateVariable dateVariable = new DateVariable(titleConf);
        this.buildSimpleVariable(dateVariableType, dateVariable, list);
        this.convertOptions(uISpecification, dateVariableType, dateVariable);
        return this.convertChildVariables(uISpecification, titleConf, dateVariableType, dateVariable, list);
    }

    private Variable convertToTimeVariable(UISpecification uISpecification, TitleConf titleConf, TimeVariableType timeVariableType, List<VariableType> list) throws SpecificationValidationException {
        TimeVariable timeVariable = new TimeVariable(titleConf);
        this.buildSimpleVariable(timeVariableType, timeVariable, list);
        this.convertOptions(uISpecification, timeVariableType, timeVariable);
        return this.convertChildVariables(uISpecification, titleConf, timeVariableType, timeVariable, list);
    }

    private Variable convertToStringVariable(UISpecification uISpecification, TitleConf titleConf, StringVariableType stringVariableType, List<VariableType> list) throws SpecificationValidationException {
        StringVariable stringVariable = new StringVariable(titleConf);
        this.buildSimpleVariable(stringVariableType, stringVariable, list);
        stringVariable.setLongFormat(stringVariableType.isLongFormat());
        this.convertOptions(uISpecification, stringVariableType, stringVariable);
        return this.convertChildVariables(uISpecification, titleConf, stringVariableType, stringVariable, list);
    }

    private void buildSimpleVariable(SimpleVariableType simpleVariableType, SimpleVariable<?> simpleVariable, List<VariableType> list) throws SpecificationValidationException {
        this.buildVariable(simpleVariableType, simpleVariable, list);
        simpleVariable.setAttribute(simpleVariableType.isAttribute());
        simpleVariable.setJobParameter(simpleVariableType.isJobParameter());
        simpleVariable.setJobRuleParameter(simpleVariableType.isJobRuleParameter());
        simpleVariable.setMsoOverridable(simpleVariableType.isMsoOverridable());
    }

    private ComplexVariable convertToComplexVariable(UISpecification uISpecification, TitleConf titleConf, VariableType variableType, List<VariableType> list) throws SpecificationValidationException {
        ComplexVariable complexVariable = new ComplexVariable(titleConf);
        this.buildVariable(variableType, complexVariable, list);
        complexVariable.setShowCollapsed(variableType.isShowCollapsed());
        List<VariableType> list2 = variableType.getVariable();
        if (list2 != null) {
            list.add(variableType);
            for (VariableType variableType2 : list2) {
                Variable variable = this.convertToVariable(uISpecification, titleConf, variableType2, list);
                complexVariable.addChild(variable);
            }
            list.remove(variableType);
        }
        return complexVariable;
    }

    private void buildVariable(VariableType variableType, Variable variable, List<VariableType> list) {
        variable.setName(variableType.getName());
        variable.setDisplayName(variableType.getDisplayName());
        variable.setXPath(this.generateXPath(variableType, list));
        variable.setMultiValue(variableType.isMultiValue());
    }

    private void loadDynamicOptions(UISpecification uISpecification, List<VariableOption> list, String string, Class clazz) throws SpecificationValidationException {
        Object object;
        Object object2;
        Object var5_5 = null;
        try {
            object2 = uISpecification.getClassLoader();
            object = ((ClassLoader)object2).loadClass(string);
            var5_5 = ((Class)object).newInstance();
        }
        catch (Exception exception) {
            String string2 = "Failed to create an instance of the variable option provider: " + string;
            throw new SpecificationValidationException(string2, exception);
        }
        if (!(var5_5 instanceof IVariableOptionProvider)) {
            object2 = "The variable option provider: " + string + " does not implement required interface: " + IVariableOptionProvider.class.getName();
            throw new SpecificationValidationException((String)object2);
        }
        try {
            object2 = var5_5;
            for (VariableOption variableOption : object2.getOptions()) {
                clazz.cast(variableOption.getValue());
                list.add(variableOption);
            }
        }
        catch (Exception exception) {
            object = "Failed to get the load options from variable option provider: " + string + ", expecting option values of type: " + clazz.getName();
            throw new SpecificationValidationException((String)object, exception);
        }
    }

    private String trim(String string) {
        return string != null ? string.trim() : null;
    }

    private String getDisplayName(String string, ResourceBundle resourceBundle) {
        if (resourceBundle != null && resourceBundle.containsKey(string)) {
            return resourceBundle.getString(string);
        }
        return string;
    }

    private String generateXPath(VariableType variableType, List<VariableType> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(PATH_SEPARATOR).append(NAMESPACE_PREFIX).append(ROOT_FIELD);
        for (VariableType variableType2 : list) {
            stringBuilder.append(PATH_SEPARATOR).append(NAMESPACE_PREFIX).append(variableType2.getName());
        }
        stringBuilder.append(PATH_SEPARATOR);
        boolean bl = false;
        if (variableType instanceof SimpleVariableType) {
            VariableType variableType2;
            variableType2 = (SimpleVariableType)variableType;
            bl = ((SimpleVariableType)variableType2).isAttribute();
        }
        stringBuilder.append(bl ? ATTRIBUTE : NAMESPACE_PREFIX);
        stringBuilder.append(variableType.getName());
        return stringBuilder.toString();
    }

    private Variable convertChildVariables(UISpecification uISpecification, TitleConf titleConf, SimpleVariableType simpleVariableType, SimpleVariable<?> simpleVariable, List<VariableType> list) throws SpecificationValidationException {
        boolean bl;
        Variable variable = simpleVariable;
        boolean bl2 = bl = simpleVariableType.getVariable() != null && simpleVariableType.getVariable().size() > 0;
        if (bl) {
            System.out.println("********************");
            ComplexVariable complexVariable = this.convertToComplexVariable(uISpecification, titleConf, simpleVariableType, list);
            complexVariable.setXPath(NAMESPACE_PREFIX);
            complexVariable.getChildren().add(0, simpleVariable);
            simpleVariable.setName(SimpleVariable.WRAPPED_FIELD_NAME);
            variable = complexVariable;
        }
        return variable;
    }
}

