##############################################################################################################
##    Script Name    : commonPostUpgradeTasks.sh                                                            ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 06/12/2013                                                                           ##
##    Usage          : ./commonPostUpgradeTasks.sh                                                          ##
##    Purpose        : Execute common tasks like changing ownership of /opt/tandbergtv                      ##
##                         to nobody:nobody, etc., which are required for all upgrade paths,                ##
##                         after the upgrades for various CMS entities are finished.                        ##
##############################################################################################################

#!/bin/sh

##
## This script performs common tasks like changing ownership of /opt/tandbergtv to nobody:nobody, etc., 
##     which are required for all upgrade paths,
##     after the upgrades for various CMS entities are finished. 
##

me=`basename $0`

logMsg "$me invoked with args: $*"

ACTIVITY="executing common post-upgrade tasks"

logBeginMsg "$ACTIVITY"


activitySeparator


SUB_ACTIVITY="recovring the version in product.version"

logBeginMsg "$SUB_ACTIVITY"

#Recover the product version from transition state to origianl state
cp /opt/tandbergtv/cms/product.properties.bak /opt/tandbergtv/cms/product.properties

logDoneMsg "$SUB_ACTIVITY"

activitySeparator

SUB_ACTIVITY="changing file ownerships to nobody:nobody"

logBeginMsg "$SUB_ACTIVITY"


## Force change ownwership of all to nobody
chown -R nobody:nobody /opt/tandbergtv/
chown -R nobody:nobody /usr/local/n2bb


if [[ -d /opt/tandbergtv/cms/jboss ]] ; then
    echo "Removing Link /opt/tandbergtv/cms/jboss"
    rm -f /opt/tandbergtv/cms/jboss
fi


logDoneMsg "$SUB_ACTIVITY"

activitySeparator

logDoneMsg "$ACTIVITY"
