##############################################################################################################
##    Script Name    : commonPreUpgradeTasks.sh                                                             ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 06/12/2013                                                                           ##
##    Usage          : ./commonPreUpgradeTasks.sh                                                           ##
##    Purpose        : Execute common tasks like creating backup directory, etc.,                           ##
##                         which are required for all upgrade paths,                                        ##
##                         before upgrades for various CMS entities are started.                            ##
##############################################################################################################

#!/bin/sh

##
## This script performs common tasks like creating backup directory, etc., 
##     which are required for all upgrade paths,
##     before upgrades for various CMS entities are started. 
##

me="commonPreUpgradeTasks.sh"

logMsg "$me invoked with args: $*"

ACTIVITY="executing common pre-upgrade tasks"

logBeginMsg "$ACTIVITY"

backupdir="$UPGRADE_HOME/$upgrade_from_cms_version"
upgradedir="$UPGRADE_HOME/$upgrade_to_cms_version"
    
export backupdir
export upgradedir
100
logMsg "backupdir=$backupdir"
logMsg "upgradedir=$upgradedir"
      
## create backup and upgrade dirs
mkdir -pv "$backupdir"
mkdir -pv "$upgradedir"

#Create link for /opt/tandbergtv/jboss
if [[ ! -d /opt/tandbergtv/cms/jboss ]] ; then 
    echo "Creating temporary Link to /opt/tandbergtv/jboss from /opt/tandbergtv/cms/jboss"
    ln -s /opt/tandbergtv/jboss /opt/tandbergtv/cms/jboss
fi

## extract 2.5 configuaration file
. ./extractTAR.sh


activitySeparator
    
logDoneMsg "$ACTIVITY"
