

printf "Starting CMS Configuration File Merger\n"

#Require Valid Search Script
if [[ -z $1 ]]; then
    printf "Please Supply The Location to CMS Merge Exclude List"
    exit 1
else 
    RESTORE_CONF=$1
fi

#Valid Tarball
if [[ -z $2 ]]; then
    printf "Please Supply Location to CMS CommonBackup Tarball\n"
    exit 1
elif ! tar tzf $2 >/dev/null ; then 
    printf "Invalid CMS CommonBackup Tarball\n"
    exit 1
else
    tar xvf $2 -C / --exclude-from=$RESTORE_CONF || die "Failed to extract from backup file"
fi

#Validate CMS version



#Mark the CMS as in-transition state
if [[ -z /opt/tandbergtv/cms/product.properties ]] ;then
        echo "Not a valid CMS app installation, please be sure this script is running on CMS app server\n"
	exit 0
else
	#make backup of product properties
	cp /opt/tandbergtv/cms/product.properties /opt/tandbergtv/cms/product.properties.bak
	export cmsVersionBeforeUpgrade=($(cat /opt/tandbergtv/cms/product.properties | grep "product.version" | cut -d "=" -f 2))
	#replace the product version to a transient upgrade state
	sed -i "s/^product.version=.*/product.version=$cmsVersionBeforeUpgrade to 4.0 in transition/" /opt/tandbergtv/cms/product.properties
fi
