#!/bin/sh
##############################################################################################################
##    Script Name    : restoreCustomization.sh                                                              ##
##    Author         : Leon Lin                                                                             ##
##    Created on     : 12/30/2013                                                                           ##
##    Usage          : ./restoreCustomization.sh                                                            ##
##    Purpose        : The main script for restoring the CMS backup files                                   ##
##                    *     from the previous version CMS app server.                                       ##
##                                                                                                          ##
##############################################################################################################
##
## Restore backed up configuration files to new 3.1 setup
##

printf "%-50s\n" "Restoring from file \"${backupTarFilePath}\"";

homedir=$(pwd) 

home=/home/upgrade
scriptsdir=$home

cd $scriptsdir

./activitySeparator.sh

MESSAGE_PREFIX="    $me: "
BEGIN_MESSAGE="begin "
START_MESSAGE=""
DONE_MESSAGE="done "

ACTIVITY="restoring backed up CMS files"
ACTIVITY_MSG="$MESSAGE_PREFIX$BEGIN_MESSAGE$ACTIVITY...$(date)"

echo "$ACTIVITY_MSG"


SUB_ACTIVITY="extracting backup tar with excludes file path: $RESTORE_CONF" 

logBeginMsg "$SUB_ACTIVITY"

cd $homedir

tar xvf $backupTarFilePath -C / --exclude-from=$RESTORE_CONF || die "Failed to extract from backup file"

logDoneMsg "$SUB_ACTIVITY"

cd $scriptsdir

activitySeparator

logDoneMsg "$ACTIVITY"

activitySeparator

cd $homedir
