#!/bin/bash

##################################################################
# Migration from 1.2 to 3.0
# Note: Version 1.2 didn't have a content class
##################################################################

# Backup old ui plugins

## Define variables
backupdir=/home/upgrade/1.2/content/plugins
upgradedir=/home/upgrade/3.1

## create backup dirs
mkdir -p $backupdir
mkdir -p $upgradedir

## Backup files
mv /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.cablelabsvod11.ui/ $backupdir/
mv /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.mstv.ui/ $backupdir/

## Convert definition.xml and properties
OLD_PATH=$backupdir/com.tandbergtv.metadata.cablelabsvod11.ui/resources
NEW_PATH=$upgradedir/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources
mkdir -p $NEW_PATH

cd upgrade25/dist/contentmgmt
./scripts/convert_12.sh $OLD_PATH definition.xml cablelabsvod11.properties $NEW_PATH
cd ../../..

## Replace old files
cp $NEW_PATH/* /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/

## Convert custom fields
cd upgrade30/dist/customfields
./scripts/custom_fields_upgrade.sh
cd ../../..
