##############################################################################################################
##    Script Name    : attCustomUpgradeTasks.sh                                                             ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 05/13/2013                                                                           ##
##    Usage          : ./attCustomUpgradeTasks.sh                                                           ##
##    Purpose        : Execute upgrade tasks required for ATT CMS 1.2 to 3.1 upgrade only.                  ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## This script executes upgrade tasks required for ATT CMS 1.2 to 3.1 upgrade only.
##

me="attCustomUpgradeTasks.sh"

logMsg "$me invoked with args: $*"

ACTIVITY="executing att custom upgrade tasks"

logBeginMsg "$ACTIVITY"

homedir=$(pwd) 

## Copy filemanager webapp as fileuploader webapp

FILEMANAGER_PATH=/opt/tandbergtv/watchpoint/tomcat-5.5.26/webapps/filemanager
FILEUPLOADER_PATH=/opt/tandbergtv/watchpoint/tomcat-5.5.26/webapps/fileuploader

mkdir -pv $FILEUPLOADER_PATH
chown -R nobody:nobody $FILEUPLOADER_PATH
 
cp -rpf $FILEMANAGER_PATH/* $FILEUPLOADER_PATH/

cd $homedir

logDoneMsg "$ACTIVITY"
