##############################################################################################################
##    Script Name    : customUpgradesFromCMS2_0.sh                                                          ##
##    Author         : Sanjay Khattar                                                                       ##
##    Created on     : 05/30/2013                                                                           ##
##    Usage          : ./customUpgradesFromCMS2_0.sh                                                        ##
##    Purpose        : Upgrade tasks required only if upgrading from CMS 2.0.                               ##
##                                                                                                          ##
##############################################################################################################

#!/bin/sh

##
## This upgrade script does upgrades which are required only if upgrading from  
##      CMS version 2.0.
##

logMsg "customUpgradesFromCMS2_0.sh invoked with args: $*"

ACTIVITY="performing upgrades required only when upgrading from CMS version $CMS_VERSION_2_0"

activitySeparator

logBeginMsg "$ACTIVITY"

## Upgrade Field Aliases
./upgradeFieldAliasFromCMS2_0.sh
    
activitySeparator

cd $SCRIPTS_DIR
     
## Upgrade ECMF ui plugin
./upgradeECMFUIPluginFromCMS2_0.sh
    
activitySeparator

cd $SCRIPTS_DIR
     
## Upgrade pmm.properties
./upgradePMMPropertiesFileFromCMS2_0.sh
    
activitySeparator

cd $SCRIPTS_DIR
     
## Upgrade ECMF ui plugin's tableconfiguration.xml
./upgradeECMFUITableConfigurationFromCMS2_0.sh
    
activitySeparator

cd $SCRIPTS_DIR
     
logDoneMsg "$ACTIVITY"
 
activitySeparator
    