#!/bin/sh
UPGRD_DIR="/home/upgrade/db_upgrade"
TIMESTAMP=`date +%Y%m%d_%H%M%S`
#copy the scripts to oracle folder
(
cp -r ${UPGRD_DIR}/createbackup /home/oracle/scripts/
if [ $? -ne 0 ]; then
  echo -e "\nError in copying the cms database upgrade script files,"
  echo "Exiting the script...\n"
  exit 1
else
  #Change ownership and executable 
  chown -R oracle:dba /home/oracle/scripts/createbackup
  chmod -R 744 /home/oracle/scripts/createbackup
fi

# Run the scripts restore and upgrade
  su - oracle -c "/home/oracle/scripts/createbackup/create_rman_backup.sh"
) 2>&1 | tee create_cmsdb_backup_$TIMESTAMP.log

